/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.cache.YopCertificateCache;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBasePlatformCredentialsProvider
implements YopPlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopBasePlatformCredentialsProvider.class);
    protected Map<String, YopPlatformCredentials> credentialsMap = Maps.newConcurrentMap();

    public YopPlatformCredentials getCredentials(String appKey, String serialNo) {
        return this.getCredentials(appKey, serialNo, null);
    }

    public YopPlatformCredentials getCredentials(String appKey, String serialNo, String serverRoot) {
        return this.getCredentials("", "", appKey, serialNo, serverRoot);
    }

    private String cacheKey(String provider, String env, String appKey, String serialNo) {
        return StringUtils.defaultString((String)provider, (String)"") + ":" + StringUtils.defaultString((String)env, (String)"") + ":" + appKey + ":" + serialNo;
    }

    public YopPlatformCredentials getCredentials(String provider, String env, String appKey, String serialNo, String serverRoot) {
        String realSerialNo;
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            throw new YopClientException("ReqParam Illegal, PlatformCert SerialNo NotSpecified");
        }
        String key = this.cacheKey(provider, env, appKey, serialNo);
        YopPlatformCredentials foundCredentials = this.credentialsMap.computeIfAbsent(key, p -> {
            if (serialNo.equals("rsa")) {
                PublicKey rsaPublicKey = this.loadLocalRsaKey(provider, env, appKey, serialNo);
                if (null == rsaPublicKey) {
                    throw new YopClientException("ConfigProblem, LocalRsaCert NotFound, provider:" + provider + ",env:" + env + ",serialNo:" + serialNo);
                }
                return this.convertCredentials(appKey, CertTypeEnum.RSA2048.getValue(), rsaPublicKey, "rsa");
            }
            YopPlatformCredentials localCredentials = this.loadCredentialsFromStore(provider, env, appKey, serialNo);
            if (null == localCredentials) {
                X509Certificate remoteCert = this.loadRemoteSm2Cert(provider, env, appKey, serialNo, serverRoot);
                if (null == remoteCert) {
                    throw new YopClientException("ConfigProblem, LocalRsaCert NotFound, provider:" + provider + ",env:" + env + ",serialNo:" + serialNo);
                }
                return this.storeCredentials(provider, env, appKey, CertTypeEnum.SM2.name(), remoteCert);
            }
            return localCredentials;
        });
        if (null != foundCredentials && !StringUtils.equals((CharSequence)(realSerialNo = foundCredentials.getSerialNo()), (CharSequence)serialNo)) {
            String realKey = this.cacheKey(provider, env, appKey, realSerialNo);
            this.credentialsMap.put(realKey, foundCredentials);
        }
        return foundCredentials;
    }

    protected abstract YopPlatformCredentials loadCredentialsFromStore(String var1, String var2);

    protected YopPlatformCredentials loadCredentialsFromStore(String provider, String env, String appKey, String serialNo) {
        return this.loadCredentialsFromStore(appKey, serialNo);
    }

    protected X509Certificate loadRemoteSm2Cert(String appKey, String serialNo) {
        return this.loadRemoteSm2Cert(appKey, serialNo, null);
    }

    protected X509Certificate loadRemoteSm2Cert(String appKey, String serialNo, String serverRoot) {
        return this.loadRemoteSm2Cert("", "", appKey, serialNo, serverRoot);
    }

    protected X509Certificate loadRemoteSm2Cert(String provider, String env, String appKey, String serialNo, String serverRoot) {
        List<X509Certificate> x509Certificates = YopCertificateCache.loadPlatformSm2Certs(provider, env, appKey, serialNo, serverRoot);
        if (CollectionUtils.isNotEmpty(x509Certificates)) {
            return x509Certificates.get(0);
        }
        return null;
    }

    protected X509Certificate loadLocalRsaCert(String appKey, String serialNo) {
        return this.loadLocalRsaCert("", "", appKey, serialNo);
    }

    protected X509Certificate loadLocalRsaCert(String provider, String env, String appKey, String serialNo) {
        return YopCertificateCache.getYopPlatformRsaCertFromLocal(provider, env, appKey, serialNo);
    }

    protected PublicKey loadLocalRsaKey(String provider, String env, String appKey, String serialNo) {
        return YopCertificateCache.getYopPlatformRsaKeyFromLocal(provider, env, appKey, serialNo);
    }

    public YopPlatformCredentials getLatestCredentials(String appKey, String credentialType) {
        return this.getLatestCredentials(appKey, credentialType, null);
    }

    public YopPlatformCredentials getLatestCredentials(String appKey, String credentialType, String serverRoot) {
        return this.getLatestCredentials("", "", appKey, credentialType, serverRoot);
    }

    public YopPlatformCredentials getLatestCredentials(String provider, String env, String appKey, String credentialType, String serverRoot) {
        try {
            CertTypeEnum parsedCertType = CertTypeEnum.parse((String)credentialType);
            if (CertTypeEnum.RSA2048.equals((Object)parsedCertType)) {
                return this.getCredentials(provider, env, appKey, "rsa", serverRoot);
            }
            return this.getSm2Credentials(provider, env, appKey, parsedCertType, serverRoot);
        }
        catch (Exception e) {
            LOGGER.warn("getLatestCredentials error, ex:", (Throwable)e);
            LOGGER.warn("No YopPlatformCredentials Found For provider:{}, env:{}, appKey:{}, credentialType:{}", new Object[]{provider, env, appKey, credentialType});
            return null;
        }
    }

    private YopPlatformCredentials getSm2Credentials(String provider, String env, String appKey, CertTypeEnum parsedCertType, String serverRoot) {
        List<X509Certificate> loadedCerts;
        try {
            loadedCerts = YopCertificateCache.loadPlatformSm2Certs(provider, env, appKey, "", serverRoot);
            if (CollectionUtils.isNotEmpty(loadedCerts) && X509CertUtils.checkCertDate(provider, env, loadedCerts.get(0))) {
                YopCertificateCache.refreshPlatformSm2Certs(provider, env, appKey, "", serverRoot);
            }
        }
        catch (CertificateException e) {
            LOGGER.warn("YopPlatformCredentials expired and need reload, appKey:" + appKey + ", credentialType:" + parsedCertType + ", ex", (Throwable)e);
            loadedCerts = YopCertificateCache.reloadPlatformSm2Certs(provider, env, appKey, "", serverRoot);
        }
        if (CollectionUtils.isEmpty(loadedCerts)) {
            LOGGER.warn("No YopPlatformCredentials Found For appKey:{}, credentialType:{}", (Object)appKey, (Object)parsedCertType);
            return null;
        }
        X509Certificate latestCert = loadedCerts.get(0);
        YopPlatformCredentials credentials = this.storeCredentials(provider, env, appKey, CertTypeEnum.SM2.name(), latestCert);
        this.credentialsMap.put(this.cacheKey(provider, env, appKey, credentials.getSerialNo()), credentials);
        return credentials;
    }

    public YopPlatformCredentials storeCredentials(String provider, String env, String appKey, String credentialType, X509Certificate certificate) {
        return this.storeCredentials(appKey, credentialType, certificate);
    }

    protected YopPlatformCredentials convertCredentials(String appKey, String credentialType, X509Certificate cert) {
        if (null == cert) {
            return null;
        }
        CertTypeEnum certType = CertTypeEnum.parse((String)credentialType);
        return new YopPlatformCredentialsHolder().withCredentials((CredentialsItem)new PKICredentialsItem(cert.getPublicKey(), certType)).withSerialNo(X509CertUtils.parseToHex(cert.getSerialNumber().toString())).withAppKey(appKey);
    }

    protected YopPlatformCredentials convertCredentials(String appKey, String credentialType, PublicKey publicKey, String keyId) {
        if (null == publicKey) {
            return null;
        }
        CertTypeEnum certType = CertTypeEnum.parse((String)credentialType);
        return new YopPlatformCredentialsHolder().withCredentials((CredentialsItem)new PKICredentialsItem(publicKey, certType)).withSerialNo(keyId).withAppKey(appKey);
    }
}

