/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.auth.signer.YopSigner;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;

public class HttpResponseHandleContext
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final String provider;
    private final String env;
    private final String appKey;
    private final YopHttpResponse response;
    private final Request originRequest;
    private final YopSigner signer;
    private final SignOptions signOptions;
    private final Boolean skipVerifySign;
    private final YopCredentials<?> yopCredentials;
    private final boolean encryptSupported;
    private final YopEncryptor encryptor;
    private final EncryptOptions encryptOptions;

    public HttpResponseHandleContext(YopHttpResponse httpResponse, Request originRequest, ExecutionContext executionContext) throws IOException, ExecutionException, InterruptedException {
        this.provider = executionContext.getProvider();
        this.env = executionContext.getEnv();
        this.appKey = originRequest.getHeaders().get("x-yop-appkey");
        this.response = httpResponse;
        this.originRequest = originRequest;
        this.signer = executionContext.getSigner();
        this.signOptions = executionContext.getSignOptions();
        this.skipVerifySign = ((BaseRequest)originRequest.getOriginalRequestObject()).getRequestConfig().getSkipVerifySign();
        this.yopCredentials = executionContext.getYopCredentials();
        this.encryptSupported = executionContext.isEncryptSupported();
        if (executionContext.isEncryptSupported()) {
            this.encryptor = executionContext.getEncryptor();
            this.encryptOptions = executionContext.getEncryptOptions().get();
        } else {
            this.encryptor = null;
            this.encryptOptions = null;
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public String getEnv() {
        return this.env;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public YopHttpResponse getResponse() {
        return this.response;
    }

    public Request getOriginRequest() {
        return this.originRequest;
    }

    public YopSigner getSigner() {
        return this.signer;
    }

    public SignOptions getSignOptions() {
        return this.signOptions;
    }

    public Boolean isSkipVerifySign() {
        return this.skipVerifySign;
    }

    public YopCredentials<?> getYopCredentials() {
        return this.yopCredentials;
    }

    public boolean isEncryptSupported() {
        return this.encryptSupported;
    }

    public YopEncryptor getEncryptor() {
        return this.encryptor;
    }

    public EncryptOptions getEncryptOptions() {
        return this.encryptOptions;
    }
}

