/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.base.cache.YopCredentialsCache;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.ClientUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestAnalyzer {
    public static YopCredentials<?> getCredentials(YopRequestConfig requestConfig, AuthorizationReq authorizationReq) {
        return RequestAnalyzer.getCredentials("", "", requestConfig, authorizationReq);
    }

    public static YopCredentials<?> getCredentials(String provider, String env, YopRequestConfig requestConfig, AuthorizationReq authorizationReq) {
        YopCredentials credential = requestConfig.getCredentials();
        if (null == credential) {
            credential = ClientUtils.getCurrentCredentialsProvider().getCredentials(provider, env, requestConfig.getAppKey(), authorizationReq.getCredentialType());
        }
        if (null == credential) {
            throw new YopClientException("No credentials specified");
        }
        YopCredentialsCache.put(provider, env, credential.getAppKey(), credential);
        return credential;
    }

    public static boolean isEncryptSupported(YopCredentials<?> credential, YopRequestConfig requestConfig) {
        if (!BooleanUtils.isFalse((Boolean)requestConfig.getNeedEncrypt())) {
            if (credential instanceof YopPKICredentials && CertTypeEnum.RSA2048.equals((Object)((YopPKICredentials)credential).getCredential().getCertType()) && "SM4/CBC/PKCS5Padding".equals(requestConfig.getEncryptAlg())) {
                requestConfig.setEncryptAlg("AES/ECB/PKCS5Padding");
            }
            return true;
        }
        return false;
    }

    public static YopEncryptor getEncryptor(YopRequestConfig requestConfig) {
        YopEncryptor encryptor;
        if (StringUtils.isBlank((CharSequence)requestConfig.getEncryptAlg())) {
            requestConfig.setEncryptAlg("SM4/CBC/PKCS5Padding");
        }
        if (null == (encryptor = YopEncryptorFactory.getEncryptor(requestConfig.getEncryptAlg()))) {
            throw new YopClientException("not supported the encryptAlg: " + requestConfig.getEncryptAlg());
        }
        return encryptor;
    }
}

