/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.model.transform;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.FileParam;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractYopRequestMarshaller
implements RequestMarshaller<YopRequest> {
    @Override
    public Request<YopRequest> marshall(YopRequest request) {
        Request<YopRequest> internalRequest = this.initRequest(request);
        internalRequest.setResourcePath(request.getApiUri());
        internalRequest.setHttpMethod(HttpMethodName.valueOf(request.getHttpMethod().toUpperCase()));
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null && customerHeaders.size() > 0) {
            for (Map.Entry<String, String> entry : customerHeaders.entrySet()) {
                internalRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!request.getParameters().isEmpty()) {
            for (Map.Entry<String, String> entry : request.getParameters().asMap().entrySet()) {
                internalRequest.addParameters(entry.getKey(), Lists.newArrayList((Iterable)((Iterable)((Object)entry.getValue()))));
            }
        }
        if (!request.getMultipartFiles().isEmpty()) {
            for (Map.Entry<String, String> entry : request.getMultipartFiles().asMap().entrySet()) {
                String name = entry.getKey();
                for (Object value : (Collection)((Object)entry.getValue())) {
                    if (value instanceof File) {
                        internalRequest.addMultiPartFile(name, (File)value);
                        continue;
                    }
                    if (value instanceof InputStream) {
                        this.resetStreamIfNecessary((InputStream)value);
                        internalRequest.addMultiPartFile(name, (InputStream)value);
                        continue;
                    }
                    if (value instanceof FileParam) {
                        this.resetStreamIfNecessary(((FileParam)value).getFileStream());
                        internalRequest.addMultiPartFile(name, (FileParam)value);
                        continue;
                    }
                    throw new YopClientException("ReqParam Illegal, FileParamType NotSupport, name:" + name + ", type:" + value.getClass() + ".");
                }
            }
            internalRequest.setContentType(YopContentType.MULTIPART_FORM);
        } else if (request.getContent() != null) {
            if (request.getContent() instanceof String) {
                byte[] contentBytes = ((String)request.getContent()).getBytes(YopConstants.DEFAULT_CHARSET);
                internalRequest.setContent(RestartableInputStream.wrap(contentBytes));
                internalRequest.addHeader("Content-Length", String.valueOf(contentBytes.length));
                internalRequest.setContentType(YopContentType.JSON);
            } else if (request.getContent() instanceof InputStream) {
                InputStream content = (InputStream)request.getContent();
                this.resetStreamIfNecessary((InputStream)request.getContent());
                internalRequest.setContent(content);
                internalRequest.setContentType(YopContentType.OCTET_STREAM);
            }
        } else {
            internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        }
        if (!YopContentType.MULTIPART_FORM.equals((Object)internalRequest.getContentType())) {
            internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        }
        return internalRequest;
    }

    private void resetStreamIfNecessary(InputStream content) {
        if (content instanceof RestartableInputStream) {
            ((RestartableInputStream)content).restart();
        }
    }

    protected abstract Request<YopRequest> initRequest(YopRequest var1);
}

