/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;

abstract class AbstractSimpleGraphBinaryCustomSerializer<T>
implements CustomTypeSerializer<T> {
    protected static final String INCORRECT_VALUE_LENGTH_ERROR_MESSAGE = "{value_length} read for this value does not correspond to the size of a '%s' value. [%s] bytes required but got [%s]";

    AbstractSimpleGraphBinaryCustomSerializer() {
    }

    protected abstract T readCustomValue(int var1, Buffer var2, GraphBinaryReader var3) throws IOException;

    protected abstract void writeCustomValue(T var1, Buffer var2, GraphBinaryWriter var3) throws IOException;

    protected void checkValueSize(int lengthRequired, int lengthFound) {
        Preconditions.checkArgument(lengthFound == lengthRequired, INCORRECT_VALUE_LENGTH_ERROR_MESSAGE, (Object)this.getTypeName(), (Object)lengthRequired, (Object)lengthFound);
    }

    public DataType getDataType() {
        return DataType.CUSTOM;
    }

    public T read(Buffer buffer, GraphBinaryReader context) throws IOException {
        if ((Integer)context.readValue(buffer, Integer.class, false) != 0) {
            throw new IOException("{custom_type_info} should not be provided for this custom type");
        }
        return this.readValue(buffer, context, true);
    }

    public T readValue(Buffer buffer, GraphBinaryReader context, boolean nullable) throws IOException {
        byte valueFlag;
        if (nullable && ((valueFlag = buffer.readByte()) & 1) == 1) {
            return null;
        }
        int valueLength = buffer.readInt();
        if (valueLength <= 0) {
            throw new IOException(String.format("Unexpected value length: %d", valueLength));
        }
        if (valueLength > buffer.readableBytes()) {
            throw new IOException(String.format("Not enough readable bytes: %d bytes required for value (%d bytes available)", valueLength, buffer.readableBytes()));
        }
        return this.readCustomValue(valueLength, buffer, context);
    }

    public void write(T value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue((Object)0, buffer, false);
        this.writeValue(value, buffer, context, true);
    }

    public void writeValue(T value, Buffer buffer, GraphBinaryWriter context, boolean nullable) throws IOException {
        if (value == null) {
            if (!nullable) {
                throw new IOException("Unexpected null value when nullable is false");
            }
            context.writeValueFlagNull(buffer);
            return;
        }
        if (nullable) {
            context.writeValueFlagNone(buffer);
        }
        this.writeCustomValue(value, buffer, context);
    }
}

