/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.shaded.guava.common.collect.HashMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimaps;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EventBus {
    private static final Logger LOG = LoggerFactory.getLogger(EventBus.class);
    private final String logPrefix;
    private final SetMultimap<Class<?>, Consumer<?>> listeners = Multimaps.synchronizedSetMultimap(HashMultimap.create());

    public EventBus(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public <EventT> Object register(Class<EventT> eventClass, Consumer<EventT> listener) {
        LOG.debug("[{}] Registering {} for {}", new Object[]{this.logPrefix, listener, eventClass});
        this.listeners.put(eventClass, listener);
        return listener;
    }

    public <EventT> boolean unregister(Object key, Class<EventT> eventClass) {
        LOG.debug("[{}] Unregistering {} for {}", new Object[]{this.logPrefix, key, eventClass});
        return this.listeners.remove(eventClass, key);
    }

    public void fire(Object event) {
        LOG.debug("[{}] Firing an instance of {}: {}", new Object[]{this.logPrefix, event.getClass(), event});
        Class<?> eventClass = event.getClass();
        Iterator iterator = this.listeners.get((Object)eventClass).iterator();
        while (iterator.hasNext()) {
            Consumer l;
            Consumer listener = l = (Consumer)iterator.next();
            LOG.debug("[{}] Notifying {} of {}", new Object[]{this.logPrefix, listener, event});
            listener.accept(event);
        }
    }
}

