/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RemoveNodeRefresh
extends NodesRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveNodeRefresh.class);
    @VisibleForTesting
    final InetSocketAddress broadcastRpcAddressToRemove;

    RemoveNodeRefresh(InetSocketAddress broadcastRpcAddressToRemove) {
        this.broadcastRpcAddressToRemove = broadcastRpcAddressToRemove;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        String logPrefix = context.getSessionName();
        Map<UUID, Node> oldNodes = oldMetadata.getNodes();
        ImmutableMap.Builder<UUID, Node> newNodesBuilder = ImmutableMap.builder();
        Node removedNode = null;
        for (Node node : oldNodes.values()) {
            if (node.getBroadcastRpcAddress().isPresent() && node.getBroadcastRpcAddress().get().equals(this.broadcastRpcAddressToRemove)) {
                removedNode = node;
                continue;
            }
            assert (node.getHostId() != null);
            newNodesBuilder.put(node.getHostId(), node);
        }
        if (removedNode == null) {
            LOG.debug("[{}] Couldn't find node {} to remove", (Object)logPrefix, (Object)this.broadcastRpcAddressToRemove);
            return new MetadataRefresh.Result(oldMetadata);
        }
        LOG.debug("[{}] Removing node {}", (Object)logPrefix, removedNode);
        return new MetadataRefresh.Result(oldMetadata.withNodes(newNodesBuilder.build(), tokenMapEnabled, false, null, context), ImmutableList.of(NodeStateEvent.removed((DefaultNode)removedNode)));
    }
}

