/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cassandra.source;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.io.IOException;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.cassandra.client.CassandraClient;
import org.apache.seatunnel.connectors.seatunnel.cassandra.config.CassandraParameters;
import org.apache.seatunnel.connectors.seatunnel.cassandra.util.TypeConvertUtil;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSourceReader
extends AbstractSingleSplitReader<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(CassandraSourceReader.class);
    private final CassandraParameters cassandraParameters;
    private final SingleSplitReaderContext readerContext;
    private CqlSession session;

    CassandraSourceReader(CassandraParameters cassandraParameters, SingleSplitReaderContext readerContext) {
        this.cassandraParameters = cassandraParameters;
        this.readerContext = readerContext;
    }

    public void open() throws Exception {
        this.session = (CqlSession)CassandraClient.getCqlSessionBuilder(this.cassandraParameters.getHost(), this.cassandraParameters.getKeyspace(), this.cassandraParameters.getUsername(), this.cassandraParameters.getPassword(), this.cassandraParameters.getDatacenter()).build();
    }

    public void close() throws IOException {
        if (this.session != null) {
            this.session.close();
        }
    }

    @Override
    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        try {
            ResultSet resultSet = this.session.execute(CassandraClient.createSimpleStatement(this.cassandraParameters.getCql(), this.cassandraParameters.getConsistencyLevel()));
            resultSet.forEach(row -> output.collect((Object)TypeConvertUtil.buildSeaTunnelRow(row)));
        }
        finally {
            this.readerContext.signalNoMoreElement();
        }
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

