/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter;

import com.mongodb.kafka.connect.sink.converter.RecordConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.BooleanFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.BytesFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Float32FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Float64FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Int16FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Int32FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Int64FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.Int8FieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.SinkFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.StringFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.logical.DateFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.logical.DecimalFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.logical.TimeFieldConverter;
import com.mongodb.kafka.connect.sink.converter.types.sink.bson.logical.TimestampFieldConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaRecordConverter
implements RecordConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRecordConverter.class);
    private static final Set<String> LOGICAL_TYPE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.apache.kafka.connect.data.Date", "org.apache.kafka.connect.data.Decimal", "org.apache.kafka.connect.data.Time", "org.apache.kafka.connect.data.Timestamp")));
    private final Map<Schema.Type, SinkFieldConverter> converters = new HashMap<Schema.Type, SinkFieldConverter>();
    private final Map<String, SinkFieldConverter> logicalConverters = new HashMap<String, SinkFieldConverter>();

    SchemaRecordConverter() {
        this.registerSinkFieldConverter(new BooleanFieldConverter());
        this.registerSinkFieldConverter(new Int8FieldConverter());
        this.registerSinkFieldConverter(new Int16FieldConverter());
        this.registerSinkFieldConverter(new Int32FieldConverter());
        this.registerSinkFieldConverter(new Int64FieldConverter());
        this.registerSinkFieldConverter(new Float32FieldConverter());
        this.registerSinkFieldConverter(new Float64FieldConverter());
        this.registerSinkFieldConverter(new StringFieldConverter());
        this.registerSinkFieldConverter(new BytesFieldConverter());
        this.registerSinkFieldLogicalConverter(new DateFieldConverter());
        this.registerSinkFieldLogicalConverter(new TimeFieldConverter());
        this.registerSinkFieldLogicalConverter(new TimestampFieldConverter());
        this.registerSinkFieldLogicalConverter(new DecimalFieldConverter());
    }

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (schema == null || value == null) {
            throw new DataException("Schema and/or value was null for AVRO conversion");
        }
        return this.toBsonDoc(schema, value).asDocument();
    }

    private void registerSinkFieldConverter(SinkFieldConverter converter) {
        this.converters.put(converter.getSchema().type(), converter);
    }

    private void registerSinkFieldLogicalConverter(SinkFieldConverter converter) {
        this.logicalConverters.put(converter.getSchema().name(), converter);
    }

    private BsonValue toBsonDoc(Schema schema, Object value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        BsonDocument doc = new BsonDocument();
        if (schema.type() == Schema.Type.MAP) {
            Schema fieldSchema = schema.valueSchema();
            Map m = (Map)value;
            for (Object entry : m.keySet()) {
                String key = (String)entry;
                if (fieldSchema.type().isPrimitive()) {
                    doc.put(key, this.getConverter(fieldSchema).toBson(m.get(key), fieldSchema));
                    continue;
                }
                if (fieldSchema.type().equals((Object)Schema.Type.ARRAY)) {
                    doc.put(key, this.toBsonArray(fieldSchema, m.get(key)));
                    continue;
                }
                if (m.get(key) == null) {
                    doc.put(key, BsonNull.VALUE);
                    continue;
                }
                doc.put(key, this.toBsonDoc(fieldSchema, m.get(key)));
            }
        } else {
            schema.fields().forEach(f -> doc.put(f.name(), this.processField((Struct)value, (Field)f)));
        }
        return doc;
    }

    private BsonValue toBsonArray(Schema schema, Object value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        Schema fieldSchema = schema.valueSchema();
        BsonArray bsonArray = new BsonArray();
        List myList = (List)value;
        myList.forEach(v -> {
            if (fieldSchema.type().isPrimitive()) {
                if (v == null) {
                    bsonArray.add(BsonNull.VALUE);
                } else {
                    bsonArray.add(this.getConverter(fieldSchema).toBson(v));
                }
            } else if (fieldSchema.type().equals((Object)Schema.Type.ARRAY)) {
                bsonArray.add(this.toBsonArray(fieldSchema, v));
            } else {
                bsonArray.add(this.toBsonDoc(fieldSchema, v));
            }
        });
        return bsonArray;
    }

    private BsonValue processField(Struct struct, Field field) {
        LOGGER.trace("processing field '{}'", (Object)field.name());
        if (struct.get(field.name()) == null) {
            LOGGER.trace("no field in struct -> adding null");
            return BsonNull.VALUE;
        }
        if (this.isSupportedLogicalType(field.schema())) {
            return this.getConverter(field.schema()).toBson(struct.get(field), field.schema());
        }
        try {
            switch (field.schema().type()) {
                case BOOLEAN: 
                case FLOAT32: 
                case FLOAT64: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case STRING: 
                case BYTES: {
                    return this.handlePrimitiveField(struct, field);
                }
                case STRUCT: 
                case MAP: {
                    return this.toBsonDoc(field.schema(), struct.get(field));
                }
                case ARRAY: {
                    return this.toBsonArray(field.schema(), struct.get(field));
                }
            }
            throw new DataException("unexpected / unsupported schema type " + field.schema().type());
        }
        catch (Exception exc) {
            throw new DataException("error while processing field " + field.name(), (Throwable)exc);
        }
    }

    private BsonValue handlePrimitiveField(Struct struct, Field field) {
        LOGGER.trace("handling primitive type '{}'", (Object)field.schema().type());
        return this.getConverter(field.schema()).toBson(struct.get(field), field.schema());
    }

    private boolean isSupportedLogicalType(Schema schema) {
        if (schema.name() == null) {
            return false;
        }
        return LOGICAL_TYPE_NAMES.contains(schema.name());
    }

    private SinkFieldConverter getConverter(Schema schema) {
        SinkFieldConverter converter = this.isSupportedLogicalType(schema) ? this.logicalConverters.get(schema.name()) : this.converters.get(schema.type());
        if (converter == null) {
            throw new ConnectException("error no registered converter found for " + schema.type().getName());
        }
        return converter;
    }
}

