/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.connector.mysql.antlr.listener.ViewSelectedColumnsParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class CreateViewParserListener
extends MySqlParserBaseListener {
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private ViewSelectedColumnsParserListener selectColumnsListener;

    public CreateViewParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    @Override
    public void enterCreateView(MySqlParser.CreateViewContext ctx) {
        if (!this.parser.skipViews()) {
            this.tableEditor = this.parser.databaseTables().editOrCreateTable(this.parser.parseQualifiedTableId(ctx.fullId()));
            if (ctx.uidList() != null) {
                ctx.uidList().uid().stream().map(this.parser::parseName).forEach(columnName -> this.tableEditor.addColumn(Column.editor().name(columnName).create()));
            }
            this.selectColumnsListener = new ViewSelectedColumnsParserListener(this.tableEditor, this.parser);
            this.listeners.add(this.selectColumnsListener);
        }
        super.enterCreateView(ctx);
    }

    @Override
    public void exitCreateView(MySqlParser.CreateViewContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.tableEditor.addColumns(this.selectColumnsListener.getSelectedColumns());
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.charsetForTable(this.tableEditor.tableId()));
            }
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.listeners.remove(this.selectColumnsListener);
        }, this.tableEditor);
        this.parser.signalCreateView(this.parser.parseQualifiedTableId(ctx.fullId()), ctx);
        super.exitCreateView(ctx);
    }
}

