/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.JdbcDataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.splitter.ChunkSplitter;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.enumerator.MySqlChunkSplitter;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.MySqlSourceFetchTaskContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.binlog.MySqlBinlogFetchTask;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan.MySqlSnapshotFetchTask;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlSchema;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.TableDiscoveryUtils;

public class MySqlDialect
implements JdbcDataSourceDialect {
    private static final String QUOTED_CHARACTER = "`";
    private static final long serialVersionUID = 1L;
    private final MySqlSourceConfig sourceConfig;
    private transient MySqlSchema mySqlSchema;
    private final Map<TableId, CatalogTable> tableMap;

    public MySqlDialect(MySqlSourceConfigFactory configFactory, List<CatalogTable> catalogTables) {
        this.sourceConfig = configFactory.create(0);
        this.tableMap = CatalogTableUtils.convertTables(catalogTables);
    }

    public String getName() {
        return "MySQL";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            boolean bl = this.isDataCollectionIdCaseSensitive(jdbcConnection);
            return bl;
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isDataCollectionIdCaseSensitive(JdbcConnection jdbcConnection) {
        return MySqlConnectionUtils.isTableIdCaseSensitive(jdbcConnection);
    }

    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return MySqlConnectionUtils.createMySqlConnection(sourceConfig.getDbzConfiguration());
    }

    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new MySqlChunkSplitter(sourceConfig, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        MySqlSourceConfig mySqlSourceConfig = (MySqlSourceConfig)sourceConfig;
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            List<TableId> list = TableDiscoveryUtils.listTables(jdbcConnection, mySqlSourceConfig.getTableFilters());
            return list;
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Error to discover tables: " + e.getMessage(), (Throwable)e);
        }
    }

    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.mySqlSchema == null) {
            this.mySqlSchema = new MySqlSchema(this.sourceConfig, this.isDataCollectionIdCaseSensitive(jdbc), this.tableMap);
        }
        return this.mySqlSchema.getTableSchema(jdbc, tableId);
    }

    public MySqlSourceFetchTaskContext createFetchTaskContext(SourceSplitBase sourceSplitBase, JdbcSourceConfig taskSourceConfig) {
        return new MySqlSourceFetchTaskContext(taskSourceConfig, this);
    }

    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new MySqlSnapshotFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new MySqlBinlogFetchTask(sourceSplitBase.asIncrementalSplit());
    }

    public Optional<PrimaryKey> getPrimaryKey(JdbcConnection jdbcConnection, TableId tableId) {
        return Optional.ofNullable(this.tableMap.get(tableId).getTableSchema().getPrimaryKey());
    }

    public List<ConstraintKey> getConstraintKeys(JdbcConnection jdbcConnection, TableId tableId) {
        return this.tableMap.get(tableId).getTableSchema().getConstraintKeys();
    }
}

