/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset;

import io.debezium.jdbc.JdbcConnection;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.JdbcDataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;

public class BinlogOffsetFactory
extends OffsetFactory {
    private final MySqlSourceConfig sourceConfig;
    private final JdbcDataSourceDialect dialect;

    public BinlogOffsetFactory(MySqlSourceConfigFactory configFactory, JdbcDataSourceDialect dialect) {
        this.sourceConfig = configFactory.create(0);
        this.dialect = dialect;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset earliest() {
        try (JdbcConnection jdbcConnection = this.dialect.openJdbcConnection((JdbcSourceConfig)this.sourceConfig);){
            BinlogOffset binlogOffset = MySqlConnectionUtils.earliestBinlogOffset(jdbcConnection);
            return binlogOffset;
        }
        catch (Exception e) {
            throw new RuntimeException("Read the binlog offset error", e);
        }
    }

    public Offset neverStop() {
        return BinlogOffset.NO_STOPPING_OFFSET;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset latest() {
        try (JdbcConnection jdbcConnection = this.dialect.openJdbcConnection((JdbcSourceConfig)this.sourceConfig);){
            BinlogOffset binlogOffset = MySqlConnectionUtils.currentBinlogOffset(jdbcConnection);
            return binlogOffset;
        }
        catch (Exception e) {
            throw new RuntimeException("Read the binlog offset error", e);
        }
    }

    public Offset specific(Map<String, String> offset) {
        return new BinlogOffset(offset);
    }

    public Offset specific(String filename, Long position) {
        return new BinlogOffset(filename, position);
    }

    public Offset timestamp(long timestamp) {
        return new BinlogOffset(timestamp / 1000L);
    }
}

