/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.parser;

import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.connectors.cdc.base.source.parser.SeatunnelDDLParser;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.parser.CustomColumnDefinitionParserListener;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlTypeUtils;

public class CustomAlterTableParserListener
extends MySqlParserBaseListener
implements SeatunnelDDLParser {
    private static final int STARTING_INDEX = 1;
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private final LinkedList<AlterTableColumnEvent> changes;
    private List<ColumnEditor> columnEditors;
    private TableIdentifier tableIdentifier;
    private CustomColumnDefinitionParserListener columnDefinitionListener;
    private int parsingColumnIndex = 1;
    private RelationalDatabaseConnectorConfig dbzConnectorConfig;

    public CustomAlterTableParserListener(RelationalDatabaseConnectorConfig dbzConnectorConfig, MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners, LinkedList<AlterTableColumnEvent> changes) {
        this.dbzConnectorConfig = dbzConnectorConfig;
        this.parser = parser;
        this.listeners = listeners;
        this.changes = changes;
    }

    @Override
    public void enterAlterTable(MySqlParser.AlterTableContext ctx) {
        TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
        this.tableIdentifier = this.toTableIdentifier(tableId);
        super.enterAlterTable(ctx);
    }

    @Override
    public void exitAlterTable(MySqlParser.AlterTableContext ctx) {
        this.listeners.remove(this.columnDefinitionListener);
        super.exitAlterTable(ctx);
        this.tableIdentifier = null;
    }

    @Override
    public void enterAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        String columnName = this.parser.parseName(ctx.uid(0));
        ColumnEditor columnEditor = Column.editor().name(columnName);
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.exitAlterByAddColumn(ctx);
    }

    @Override
    public void exitAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            org.apache.seatunnel.api.table.catalog.Column seatunnelColumn = this.toSeatunnelColumnWithFullTypeInfo(column);
            if (ctx.FIRST() != null) {
                AlterTableAddColumnEvent alterTableAddColumnEvent = AlterTableAddColumnEvent.addFirst((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn);
                this.changes.add((AlterTableColumnEvent)alterTableAddColumnEvent);
            } else if (ctx.AFTER() != null) {
                String afterColumn = this.parser.parseName(ctx.uid(1));
                AlterTableAddColumnEvent alterTableAddColumnEvent = AlterTableAddColumnEvent.addAfter((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn, (String)afterColumn);
                this.changes.add((AlterTableColumnEvent)alterTableAddColumnEvent);
            } else {
                AlterTableAddColumnEvent alterTableAddColumnEvent = AlterTableAddColumnEvent.add((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn);
                this.changes.add((AlterTableColumnEvent)alterTableAddColumnEvent);
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByAddColumn(ctx);
    }

    @Override
    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null && this.columnEditors.size() > this.parsingColumnIndex) {
                this.columnDefinitionListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
            }
        }, this.columnEditors);
        super.exitColumnDefinition(ctx);
    }

    @Override
    public void enterAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        String columnName = this.parser.parseName(ctx.uid(0));
        ColumnEditor columnEditor = Column.editor().name(columnName);
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByModifyColumn(ctx);
    }

    @Override
    public void exitAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            org.apache.seatunnel.api.table.catalog.Column seatunnelColumn = this.toSeatunnelColumnWithFullTypeInfo(column);
            if (ctx.FIRST() != null) {
                AlterTableModifyColumnEvent alterTableModifyColumnEvent = AlterTableModifyColumnEvent.modifyFirst((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn);
                this.changes.add((AlterTableColumnEvent)alterTableModifyColumnEvent);
            } else if (ctx.AFTER() != null) {
                String afterColumn = this.parser.parseName(ctx.uid(1));
                AlterTableModifyColumnEvent alterTableModifyColumnEvent = AlterTableModifyColumnEvent.modifyAfter((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn, (String)afterColumn);
                this.changes.add((AlterTableColumnEvent)alterTableModifyColumnEvent);
            } else {
                AlterTableModifyColumnEvent alterTableModifyColumnEvent = AlterTableModifyColumnEvent.modify((TableIdentifier)this.tableIdentifier, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn);
                this.changes.add((AlterTableColumnEvent)alterTableModifyColumnEvent);
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByModifyColumn(ctx);
    }

    @Override
    public void enterAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        String oldColumnName = this.parser.parseName(ctx.oldColumn);
        ColumnEditor columnEditor = Column.editor().name(oldColumnName);
        columnEditor.unsetDefaultValueExpression();
        this.columnDefinitionListener = new CustomColumnDefinitionParserListener(columnEditor, this.parser, this.listeners);
        this.listeners.add(this.columnDefinitionListener);
        super.enterAlterByChangeColumn(ctx);
    }

    @Override
    public void exitAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            org.apache.seatunnel.api.table.catalog.Column seatunnelColumn = this.toSeatunnelColumnWithFullTypeInfo(column);
            String oldColumnName = column.name();
            String newColumnName = this.parser.parseName(ctx.newColumn);
            seatunnelColumn = seatunnelColumn.rename(newColumnName);
            AlterTableChangeColumnEvent alterTableChangeColumnEvent = AlterTableChangeColumnEvent.change((TableIdentifier)this.tableIdentifier, (String)oldColumnName, (org.apache.seatunnel.api.table.catalog.Column)seatunnelColumn);
            if (StringUtils.isNotBlank((CharSequence)newColumnName) && !StringUtils.equals((CharSequence)oldColumnName, (CharSequence)newColumnName)) {
                this.changes.add((AlterTableColumnEvent)alterTableChangeColumnEvent);
            }
            this.listeners.remove(this.columnDefinitionListener);
        }, this.columnDefinitionListener);
        super.exitAlterByChangeColumn(ctx);
    }

    @Override
    public void enterAlterByDropColumn(MySqlParser.AlterByDropColumnContext ctx) {
        String removedColName = this.parser.parseName(ctx.uid());
        this.changes.add((AlterTableColumnEvent)new AlterTableDropColumnEvent(this.tableIdentifier, removedColName));
        super.enterAlterByDropColumn(ctx);
    }

    public org.apache.seatunnel.api.table.catalog.Column toSeatunnelColumn(Column column) {
        return MySqlTypeUtils.convertToSeaTunnelColumn(column, this.dbzConnectorConfig);
    }
}

