/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Calendar;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.seatunnel.connectors.cdc.base.relational.JdbcSourceEventDispatcher;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkKind;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.reader.fetch.scan.SnapshotSplitChangeEventSourceContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlConnectionUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSnapshotSplitReadTask
extends AbstractSnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSnapshotSplitReadTask.class);
    private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final MySqlConnection jdbcConnection;
    private final JdbcSourceEventDispatcher<MySqlPartition> dispatcher;
    private final Clock clock;
    private final SnapshotSplit snapshotSplit;
    private final MySqlOffsetContext offsetContext;
    private final SnapshotProgressListener<MySqlPartition> snapshotProgressListener;

    public MySqlSnapshotSplitReadTask(MySqlConnectorConfig connectorConfig, MySqlOffsetContext previousOffset, SnapshotProgressListener<MySqlPartition> snapshotProgressListener, MySqlDatabaseSchema databaseSchema, MySqlConnection jdbcConnection, JdbcSourceEventDispatcher<MySqlPartition> dispatcher, SnapshotSplit snapshotSplit) {
        super((CommonConnectorConfig)connectorConfig, snapshotProgressListener);
        this.offsetContext = previousOffset;
        this.connectorConfig = connectorConfig;
        this.databaseSchema = databaseSchema;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = Clock.SYSTEM;
        this.snapshotSplit = snapshotSplit;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    public SnapshotResult<MySqlOffsetContext> execute(ChangeEventSource.ChangeEventSourceContext context, MySqlPartition partition, MySqlOffsetContext previousOffset) throws InterruptedException {
        MySqlSnapshotContext ctx;
        AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
        try {
            ctx = this.prepare(partition);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return this.doExecute(context, previousOffset, (AbstractSnapshotChangeEventSource.SnapshotContext<MySqlPartition, MySqlOffsetContext>)ctx, snapshottingTask);
        }
        catch (InterruptedException e) {
            LOG.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            throw new DebeziumException((Throwable)t);
        }
    }

    protected SnapshotResult<MySqlOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, MySqlOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<MySqlPartition, MySqlOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        MySqlSnapshotContext ctx = (MySqlSnapshotContext)snapshotContext;
        ctx.offset = this.offsetContext;
        BinlogOffset lowWatermark = MySqlConnectionUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 1 - Determining low watermark {} for split {}", (Object)lowWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitChangeEventSourceContext)context).setLowWatermark(lowWatermark);
        this.dispatcher.dispatchWatermarkEvent(((MySqlPartition)ctx.partition).getSourcePartition(), (SourceSplitBase)this.snapshotSplit, (Offset)lowWatermark, WatermarkKind.LOW);
        LOG.info("Snapshot step 2 - Snapshotting data");
        this.createDataEvents(ctx, this.snapshotSplit.getTableId());
        BinlogOffset highWatermark = MySqlConnectionUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 3 - Determining high watermark {} for split {}", (Object)highWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitChangeEventSourceContext)context).setHighWatermark(highWatermark);
        this.dispatcher.dispatchWatermarkEvent(((MySqlPartition)ctx.partition).getSourcePartition(), (SourceSplitBase)this.snapshotSplit, (Offset)highWatermark, WatermarkKind.HIGH);
        return SnapshotResult.completed((OffsetContext)ctx.offset);
    }

    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(MySqlPartition partition, MySqlOffsetContext previousOffset) {
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
    }

    protected MySqlSnapshotContext prepare(MySqlPartition partition) throws Exception {
        return new MySqlSnapshotContext(partition);
    }

    private void createDataEvents(MySqlSnapshotContext snapshotContext, TableId tableId) throws Exception {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        LOG.debug("Snapshotting table {}", (Object)tableId);
        this.createDataEventsForTable(snapshotContext, (EventDispatcher.SnapshotReceiver<MySqlPartition>)snapshotReceiver, this.databaseSchema.tableFor(tableId));
        snapshotReceiver.completeSnapshot();
    }

    private void createDataEventsForTable(MySqlSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MySqlPartition> snapshotReceiver, Table table) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
        String selectSql = MySqlUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
        LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
        try (PreparedStatement selectStatement = MySqlUtils.readTableSplitDataStatement(this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType(), this.connectorConfig.getSnapshotFetchSize());
             ResultSet rs = selectStatement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray((ResultSet)rs, (Table)table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            while (rs.next()) {
                ++rows;
                Object[] row = new Object[columnArray.getGreatestColumnPosition()];
                for (int i = 0; i < columnArray.getColumns().length; ++i) {
                    Column actualColumn = (Column)table.columns().get(i);
                    row[columnArray.getColumns()[i].position() - 1] = this.readField(rs, i + 1, actualColumn, table);
                }
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(stop - exportStart))});
                    this.snapshotProgressListener.rowsScanned(snapshotContext.partition, table.id(), rows);
                    logTimer = this.getTableScanLogTimer();
                }
                this.dispatcher.dispatchSnapshotEvent(snapshotContext.partition, (DataCollectionId)table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
            }
            LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
        }
    }

    protected ChangeRecordEmitter<MySqlPartition> getChangeRecordEmitter(MySqlSnapshotContext snapshotContext, TableId tableId, Object[] row) {
        ((MySqlOffsetContext)snapshotContext.offset).event((DataCollectionId)tableId, this.clock.currentTime());
        return new SnapshotChangeRecordEmitter(snapshotContext.partition, snapshotContext.offset, row, this.clock);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer((Clock)this.clock, (Duration)LOG_INTERVAL);
    }

    private Object readField(ResultSet rs, int fieldNo, Column actualColumn, Table actualTable) throws SQLException {
        if (actualColumn.jdbcType() == 92) {
            return this.readTimeField(rs, fieldNo);
        }
        if (actualColumn.jdbcType() == 91) {
            return this.readDateField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == 93) {
            return this.readTimestampField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == -6 || actualColumn.jdbcType() == 5) {
            return rs.getObject(fieldNo) == null ? null : Integer.valueOf(rs.getInt(fieldNo));
        }
        return rs.getObject(fieldNo);
    }

    private Object readTimeField(ResultSet rs, int fieldNo) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToDuration(new String(b.getBytes(1L, (int)b.length()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readDateField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToLocalDate(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readTimestampField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.containsZeroValuesInDatePart(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table) ? null : rs.getTimestamp(fieldNo, Calendar.getInstance());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private static class MySqlSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<MySqlPartition, MySqlOffsetContext> {
        public MySqlSnapshotContext(MySqlPartition partition) throws SQLException {
            super((Partition)partition, "");
        }
    }
}

