/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.CustomMySqlConnectionConfiguration;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffset;

public class MySqlConnectionUtils {
    public static MySqlConnection createMySqlConnection(Configuration dbzConfiguration) {
        return new MySqlConnection(new CustomMySqlConnectionConfiguration(dbzConfiguration));
    }

    public static BinaryLogClient createBinaryClient(Configuration dbzConfiguration) {
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(dbzConfiguration);
        return new BinaryLogClient(connectorConfig.hostname(), connectorConfig.port(), connectorConfig.username(), connectorConfig.password());
    }

    public static MySqlDatabaseSchema createMySqlDatabaseSchema(MySqlConnectorConfig dbzMySqlConfig, boolean isTableIdCaseSensitive) {
        TopicSelector<TableId> topicSelector = MySqlTopicSelector.defaultSelector(dbzMySqlConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        MySqlValueConverters valueConverters = MySqlConnectionUtils.getValueConverters(dbzMySqlConfig);
        return new MySqlDatabaseSchema(dbzMySqlConfig, valueConverters, topicSelector, schemaNameAdjuster, isTableIdCaseSensitive);
    }

    public static BinlogOffset earliestBinlogOffset(JdbcConnection jdbc) {
        String showMasterStmt = ((MySqlConnection)jdbc).binaryLogStatusStatement().startsWith("SHOW BINARY") ? "SHOW BINARY LOGS" : "SHOW MASTER LOGS";
        JdbcConnection.ResultSetMapper getCurrentBinlogOffset = rs -> {
            String binlogFilename = rs.getString(1);
            long binlogPosition = 4L;
            return new BinlogOffset(binlogFilename, 4L, 0L, 0L, 0L, null, null);
        };
        return MySqlConnectionUtils.getBinlogOffset(jdbc, showMasterStmt, (JdbcConnection.ResultSetMapper<BinlogOffset>)getCurrentBinlogOffset);
    }

    public static BinlogOffset currentBinlogOffset(JdbcConnection jdbc) {
        MySqlConnection mySqlConnection = (MySqlConnection)jdbc;
        JdbcConnection.ResultSetMapper getCurrentBinlogOffset = rs -> {
            String binlogFilename = rs.getString(1);
            long binlogPosition = rs.getLong(2);
            String gtidSet = rs.getMetaData().getColumnCount() > 4 ? rs.getString(5) : null;
            return new BinlogOffset(binlogFilename, binlogPosition, 0L, 0L, 0L, gtidSet, null);
        };
        return MySqlConnectionUtils.getBinlogOffset(jdbc, mySqlConnection.binaryLogStatusStatement(), (JdbcConnection.ResultSetMapper<BinlogOffset>)getCurrentBinlogOffset);
    }

    private static BinlogOffset getBinlogOffset(JdbcConnection jdbc, String showMasterStmt, JdbcConnection.ResultSetMapper<BinlogOffset> function) {
        try {
            return (BinlogOffset)((Object)jdbc.queryAndMap(showMasterStmt, rs -> {
                if (rs.next()) {
                    return (BinlogOffset)((Object)((Object)function.apply(rs)));
                }
                throw new SeaTunnelException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
            }));
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured", (Throwable)e);
        }
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig dbzMySqlConfig) {
        TemporalPrecisionMode timePrecisionMode = dbzMySqlConfig.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = dbzMySqlConfig.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = dbzMySqlConfig.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = dbzMySqlConfig.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, dbzMySqlConfig.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, MySqlValueConverters::defaultParsingErrorHandler);
    }

    public static boolean isTableIdCaseSensitive(JdbcConnection connection) {
        return !"0".equals(MySqlConnectionUtils.readMySqlSystemVariables(connection).get("lower_case_table_names"));
    }

    public static Map<String, String> readMySqlSystemVariables(JdbcConnection connection) {
        return MySqlConnectionUtils.querySystemVariables(connection, "SHOW VARIABLES");
    }

    private static Map<String, String> querySystemVariables(JdbcConnection connection, String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            connection.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                }
            });
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    public static BinlogOffset findBinlogOffsetBytimestamp(JdbcConnection jdbc, BinaryLogClient client, long timestamp) {
        String showBinaryLogStmt = ((MySqlConnection)jdbc).binaryLogStatusStatement().startsWith("SHOW BINARY") ? "SHOW BINARY LOGS" : "SHOW MASTER LOGS";
        ArrayList<String> binlogFiles = new ArrayList<String>();
        JdbcConnection.ResultSetConsumer rsc = rs -> {
            while (rs.next()) {
                String fileName = rs.getString(1);
                long fileSize = rs.getLong(2);
                if (fileSize <= 0L) continue;
                binlogFiles.add(fileName);
            }
        };
        try {
            jdbc.query(showBinaryLogStmt, rsc);
            if (binlogFiles.isEmpty()) {
                return BinlogOffset.INITIAL_OFFSET;
            }
            String binlogName = MySqlConnectionUtils.searchBinlogName(client, timestamp, binlogFiles);
            return new BinlogOffset(binlogName, 0L);
        }
        catch (Exception e) {
            throw new SeaTunnelException((Throwable)e);
        }
    }

    private static String searchBinlogName(BinaryLogClient client, long targetMs, List<String> binlogFiles) throws IOException, InterruptedException {
        int startIdx = 0;
        int endIdx = binlogFiles.size() - 1;
        while (startIdx <= endIdx) {
            int mid = startIdx + (endIdx - startIdx) / 2;
            long midTs = MySqlConnectionUtils.getBinlogTimestamp(client, binlogFiles.get(mid));
            if (midTs < targetMs) {
                startIdx = mid + 1;
                continue;
            }
            if (targetMs < midTs) {
                endIdx = mid - 1;
                continue;
            }
            return binlogFiles.get(mid);
        }
        return endIdx < 0 ? binlogFiles.get(0) : binlogFiles.get(endIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBinlogTimestamp(BinaryLogClient client, String binlogFile) throws IOException {
        AtomicLong binlogTimestamps = new AtomicLong();
        BinaryLogClient.EventListener eventListener = event -> {
            Object data = event.getData();
            if (data instanceof RotateEventData) {
                return;
            }
            EventHeaderV4 header = (EventHeaderV4)event.getHeader();
            long timestamp = header.getTimestamp();
            if (timestamp > 0L && binlogTimestamps.get() == 0L) {
                binlogTimestamps.set(timestamp);
                try {
                    client.disconnect();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            client.registerEventListener(eventListener);
            client.setBinlogFilename(binlogFile);
            client.setBinlogPosition(0L);
            client.connect();
        }
        finally {
            client.unregisterEventListener(eventListener);
        }
        return binlogTimestamps.get();
    }
}

