/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.xa.Xid;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.GroupXaOperationResult;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XaFacade;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XaGroupOps;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XidGenerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.xa.XidImpl;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.XidInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaGroupOpsImpl
implements XaGroupOps {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(XaGroupOpsImpl.class);
    private final XaFacade xaFacade;

    public XaGroupOpsImpl(XaFacade xaFacade) {
        this.xaFacade = xaFacade;
    }

    @Override
    public GroupXaOperationResult<XidInfo> commit(List<XidInfo> xids, boolean allowOutOfOrderCommits, int maxCommitAttempts) {
        GroupXaOperationResult<XidInfo> result = new GroupXaOperationResult<XidInfo>();
        int origSize = xids.size();
        LOG.info("commit {} transactions", (Object)origSize);
        Iterator<XidInfo> i = xids.iterator();
        while (i.hasNext() && (result.hasNoFailures() || allowOutOfOrderCommits)) {
            XidInfo x = i.next();
            i.remove();
            try {
                LOG.info("committing {} transaction", (Object)x.getXid());
                this.xaFacade.commit(x.getXid(), false);
                result.succeeded(x);
            }
            catch (XaFacade.TransientXaException e) {
                result.failedTransiently(x.withAttemptsIncremented(), e);
            }
            catch (Exception e) {
                result.failed(x, e);
            }
        }
        result.getForRetry().addAll(xids);
        XaGroupOpsImpl.throwIfAnyReachedMaxAttempts(result, maxCommitAttempts);
        result.getTransientFailure().ifPresent(f -> LOG.warn("failed to commit {} transactions out of {} (keep them to retry later)", new Object[]{result.getForRetry().size(), origSize, f}));
        return result;
    }

    @Override
    public void rollback(List<XidInfo> xids) {
        for (XidInfo x : xids) {
            this.xaFacade.rollback(x.getXid());
        }
    }

    @Override
    public GroupXaOperationResult<XidInfo> failAndRollback(Collection<XidInfo> xids) {
        GroupXaOperationResult<XidInfo> result = new GroupXaOperationResult<XidInfo>();
        if (xids.isEmpty()) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rolling back {} transactions: {}", (Object)xids.size(), xids);
        }
        for (XidInfo x : xids) {
            try {
                this.xaFacade.failAndRollback(x.getXid());
                result.succeeded(x);
            }
            catch (XaFacade.TransientXaException e) {
                LOG.info("unable to fail/rollback transaction, xid={}: {}", (Object)x, (Object)e.getMessage());
                result.failedTransiently(x, e);
            }
            catch (Exception e) {
                LOG.warn("unable to fail/rollback transaction, xid={}: {}", (Object)x, (Object)e.getMessage());
                result.failed(x, e);
            }
        }
        if (!result.getForRetry().isEmpty()) {
            LOG.info("failed to roll back {} transactions", (Object)result.getForRetry().size());
        }
        return result;
    }

    @Override
    public void recoverAndRollback(JobContext context, SinkWriter.Context sinkContext, XidGenerator xidGenerator, Xid excludeXid) {
        Collection recovered = this.xaFacade.recover().stream().map(x -> new XidImpl(x.getFormatId(), x.getGlobalTransactionId(), x.getBranchQualifier())).collect(Collectors.toList());
        recovered.remove(excludeXid);
        if (recovered.isEmpty()) {
            return;
        }
        LOG.warn("rollback {} recovered transactions", (Object)recovered.size());
        for (Xid xid : recovered) {
            if (!xidGenerator.belongsToSubtask(xid, context, sinkContext)) continue;
            try {
                this.xaFacade.rollback(xid);
            }
            catch (Exception e) {
                LOG.info("unable to rollback recovered transaction, xid={}", (Object)xid, (Object)e);
            }
        }
    }

    private static void throwIfAnyReachedMaxAttempts(GroupXaOperationResult<XidInfo> result, int maxAttempts) {
        ArrayList<XidInfo> reached = null;
        for (XidInfo x : result.getForRetry()) {
            if (x.getAttempts() < maxAttempts) continue;
            if (reached == null) {
                reached = new ArrayList<XidInfo>();
            }
            reached.add(x);
        }
        if (reached != null) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.XA_OPERATION_FAILED, String.format("reached max number of commit attempts (%d) for transactions: %s", maxAttempts, reached));
        }
    }
}

