/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.util.Collect;
import java.util.Set;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;

public class PostgresErrorHandler
extends ErrorHandler {
    @Immutable
    private static final Set<String> RETRIABLE_EXCEPTION_MESSSAGES = Collect.unmodifiableSet((Object[])new String[]{"Database connection failed when writing to copy", "Database connection failed when reading from copy", "An I/O error occurred while sending to the backend", "ERROR: could not open relation with OID", "This connection has been closed", "terminating connection due to unexpected postmaster exit", "terminating connection due to administrator command"});

    public PostgresErrorHandler(PostgresConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        super(PostgresConnector.class, (CommonConnectorConfig)connectorConfig, queue);
    }

    protected boolean isRetriable(Throwable throwable) {
        if (this.isRetriablePsqlException(throwable)) {
            return true;
        }
        if (throwable instanceof DebeziumException) {
            return this.isRetriablePsqlException(throwable.getCause());
        }
        return false;
    }

    public boolean isRetriablePsqlException(Throwable throwable) {
        if (throwable != null && throwable instanceof PSQLException && throwable.getMessage() != null) {
            for (String messageText : RETRIABLE_EXCEPTION_MESSSAGES) {
                if (!throwable.getMessage().contains(messageText)) continue;
                return true;
            }
        }
        return false;
    }
}

