/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.exception.PostgresConnectorErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresObjectUtils {
    private static final Logger log = LoggerFactory.getLogger(PostgresObjectUtils.class);

    public static PostgresSchema newSchema(PostgresConnection connection, PostgresConnectorConfig config, TypeRegistry typeRegistry, TopicSelector<TableId> topicSelector, PostgresValueConverter valueConverter) throws SQLException {
        PostgresSchema schema = new PostgresSchema(config, typeRegistry, connection.getDefaultValueConverter(), topicSelector, valueConverter);
        schema.refresh(connection, false);
        return schema;
    }

    public static PostgresEventMetadataProvider newEventMetadataProvider() {
        return new PostgresEventMetadataProvider();
    }

    public static PostgresTaskContext newTaskContext(PostgresConnectorConfig connectorConfig, PostgresSchema schema, TopicSelector<TableId> topicSelector) {
        return new PostgresTaskContext(connectorConfig, schema, topicSelector);
    }

    public static ReplicationConnection createReplicationConnection(PostgresTaskContext taskContext, PostgresConnection postgresConnection, boolean doSnapshot, PostgresConnectorConfig connectorConfig) {
        short s = connectorConfig.maxRetries();
        Duration retryDelay = connectorConfig.retryDelay();
        Metronome metronome = Metronome.parker((Duration)retryDelay, (Clock)Clock.SYSTEM);
        short retryCount = 0;
        while (retryCount <= s) {
            try {
                log.info("Creating a new replication connection for {}", (Object)taskContext);
                return taskContext.createReplicationConnection(doSnapshot, postgresConnection);
            }
            catch (SQLException ex) {
                retryCount = (short)(retryCount + 1);
                if (retryCount > s) {
                    log.error("Too many errors connecting to server. All {} retries failed.", (Object)s);
                    throw new ConnectException((Throwable)ex);
                }
                log.warn("Error connecting to server; will attempt retry {} of {} after {} seconds. Exception message: {}", new Object[]{retryCount, (int)s, retryDelay.getSeconds(), ex.getMessage()});
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    log.warn("Connection retry sleep interrupted by exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)PostgresConnectorErrorCode.CREATE_REPLICATION_CONNECTION_FAILED, "" + (Object)((Object)taskContext));
    }
}

