/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.wal2json.DateTimeFormat;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGbox;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGcircle;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGline;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGlseg;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGpath;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGpoint;
import org.apache.seatunnel.shade.org.postgresql.geometric.PGpolygon;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgArray;
import org.apache.seatunnel.shade.org.postgresql.util.PGInterval;
import org.apache.seatunnel.shade.org.postgresql.util.PGmoney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnValue<T>
implements ReplicationMessage.ColumnValue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractColumnValue.class);

    @Override
    public LocalDate asLocalDate() {
        return DateTimeFormat.get().date(this.asString());
    }

    @Override
    public Object asTime() {
        return this.asString();
    }

    @Override
    public Object asLocalTime() {
        return DateTimeFormat.get().time(this.asString());
    }

    @Override
    public OffsetTime asOffsetTimeUtc() {
        return DateTimeFormat.get().timeWithTimeZone(this.asString());
    }

    @Override
    public OffsetDateTime asOffsetDateTimeAtUtc() {
        if ("infinity".equals(this.asString())) {
            return PostgresValueConverter.POSITIVE_INFINITY_OFFSET_DATE_TIME;
        }
        if ("-infinity".equals(this.asString())) {
            return PostgresValueConverter.NEGATIVE_INFINITY_OFFSET_DATE_TIME;
        }
        return DateTimeFormat.get().timestampWithTimeZoneToOffsetDateTime(this.asString()).withOffsetSameInstant(ZoneOffset.UTC);
    }

    @Override
    public Instant asInstant() {
        if ("infinity".equals(this.asString())) {
            return PostgresValueConverter.POSITIVE_INFINITY_INSTANT;
        }
        if ("-infinity".equals(this.asString())) {
            return PostgresValueConverter.NEGATIVE_INFINITY_INSTANT;
        }
        return DateTimeFormat.get().timestampToInstant(this.asString());
    }

    @Override
    public PGbox asBox() {
        try {
            return new PGbox(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGcircle asCircle() {
        try {
            return new PGcircle(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse circle {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public Object asInterval() {
        try {
            return new PGInterval(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGline asLine() {
        try {
            return new PGline(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGlseg asLseg() {
        try {
            return new PGlseg(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGmoney asMoney() {
        try {
            String value = this.asString();
            if (value != null && value.startsWith("-")) {
                String negativeMoney = "(" + value.substring(1) + ")";
                return new PGmoney(negativeMoney);
            }
            return new PGmoney(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse money {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpath asPath() {
        try {
            return new PGpath(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpoint asPoint() {
        try {
            return new PGpoint(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpolygon asPolygon() {
        try {
            return new PGpolygon(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public boolean isArray(PostgresType type) {
        return type.isArrayType();
    }

    @Override
    public Object asArray(String columnName, PostgresType type, String fullType, PostgresStreamingChangeEventSource.PgConnectionSupplier connection) {
        try {
            String dataString = this.asString();
            return new PgArray(connection.get(), type.getOid(), dataString);
        }
        catch (SQLException e) {
            LOGGER.warn("Unexpected exception trying to process PgArray ({}) column '{}', {}", new Object[]{fullType, columnName, e});
            return null;
        }
    }

    @Override
    public Object asDefault(TypeRegistry typeRegistry, int columnType, String columnName, String fullType, boolean includeUnknownDatatypes, PostgresStreamingChangeEventSource.PgConnectionSupplier connection) {
        if (includeUnknownDatatypes) {
            LOGGER.debug("processing column '{}' with unknown data type '{}' as byte array", (Object)columnName, (Object)fullType);
            return this.asString();
        }
        LOGGER.debug("Unknown column type {} for column {} \u2013\u00a0ignoring", (Object)fullType, (Object)columnName);
        return null;
    }
}

