/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.config;

import io.debezium.connector.postgresql.PostgresConnector;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfigFactory;
import org.apache.seatunnel.connectors.cdc.debezium.EmbeddedDatabaseHistory;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.config.PostgresSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.option.PostgresOptions;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class PostgresSourceConfigFactory
extends JdbcSourceConfigFactory {
    private static final String DATABASE_SERVER_NAME = "postgres_cdc_source";
    private static final String DRIVER_CLASS_NAME = "org.apache.seatunnel.shade.org.postgresql.Driver";
    private String decodingPluginName = (String)PostgresOptions.DECODING_PLUGIN_NAME.defaultValue();
    private String slotName = (String)PostgresOptions.SLOT_NAME.defaultValue();
    private List<String> schemaList;

    public JdbcSourceConfigFactory fromReadonlyConfig(ReadonlyConfig config) {
        super.fromReadonlyConfig(config);
        this.decodingPluginName = (String)config.get(PostgresOptions.DECODING_PLUGIN_NAME);
        this.slotName = (String)config.get(PostgresOptions.SLOT_NAME);
        this.schemaList = (List)config.get(PostgresOptions.SCHEMA_NAME);
        return this;
    }

    public PostgresSourceConfig create(int subtask) {
        Properties props = new Properties();
        props.setProperty("connector.class", PostgresConnector.class.getCanonicalName());
        props.setProperty("database.server.name", DATABASE_SERVER_NAME);
        props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.dbname", (String)Preconditions.checkNotNull(this.databaseList.get(0)));
        props.setProperty("plugin.name", this.decodingPluginName);
        props.setProperty("slot.name", this.slotName);
        props.setProperty("database.history", EmbeddedDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtask);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("database.tcpKeepAlive", String.valueOf(true));
        props.setProperty("include.schema.changes", String.valueOf(false));
        if (this.schemaList != null) {
            props.setProperty("schema.include.list", String.join((CharSequence)",", this.schemaList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", this.tableList.stream().map(tableStr -> {
                String[] splits = tableStr.split("\\.");
                if (splits.length == 2) {
                    return tableStr;
                }
                if (splits.length == 3) {
                    return String.join((CharSequence)".", splits[1], splits[2]);
                }
                throw new IllegalArgumentException("Invalid table name: " + tableStr + " ,Postgres identifier is of the form schemaName.tableName");
            }).collect(Collectors.joining(",")));
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        return new PostgresSourceConfig(this.startupConfig, this.stopConfig, this.databaseList, this.tableList, this.splitSize, this.splitColumn, this.distributionFactorUpper, this.distributionFactorLower, this.sampleShardingThreshold, this.inverseSamplingRate, props, DRIVER_CLASS_NAME, this.hostname, this.port, this.username, this.password, this.originUrl, this.fetchSize, this.serverTimeZone, this.connectTimeoutMillis, this.connectMaxRetries, this.connectionPoolSize, this.exactlyOnce);
    }
}

