/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.clusterhealthy;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.seatunnel.shade.org.postgresql.GlobalConnectionTracker;
import org.apache.seatunnel.shade.org.postgresql.PGProperty;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterHeartBeatFailureCluster;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterHeartBeatFailureMaster;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterHeartBeatMaster;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterNodeCache;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.FailureCluster;
import org.apache.seatunnel.shade.org.postgresql.core.PGStream;
import org.apache.seatunnel.shade.org.postgresql.core.QueryExecutor;
import org.apache.seatunnel.shade.org.postgresql.core.SocketFactoryFactory;
import org.apache.seatunnel.shade.org.postgresql.core.v3.ConnectionFactoryImpl;
import org.apache.seatunnel.shade.org.postgresql.core.v3.QueryExecutorImpl;
import org.apache.seatunnel.shade.org.postgresql.jdbc.SslMode;
import org.apache.seatunnel.shade.org.postgresql.log.Log;
import org.apache.seatunnel.shade.org.postgresql.log.Logger;
import org.apache.seatunnel.shade.org.postgresql.util.HostSpec;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

public class ClusterHeartBeat {
    public static final Map<HostSpec, Set<Properties>> CLUSTER_PROPERTIES = new ConcurrentHashMap<HostSpec, Set<Properties>>();
    private Log LOGGER = Logger.getLogger(ClusterHeartBeat.class.getName());
    private final ConnectionFactoryImpl FACTORY = new ConnectionFactoryImpl();
    private final String clientEncoding = "UTF8";
    private volatile boolean detection;
    private final Long defaultInterval = 5000L;
    private final String DEFAULT_TIMEOUT = "30000";
    private volatile AtomicLong periodTime = new AtomicLong(this.defaultInterval);

    public void masterNodeProbe() {
        while (ClusterNodeCache.isOpen()) {
            if (this.detection && ClusterHeartBeatFailureCluster.getInstance().failureCluster.isEmpty() && !GlobalConnectionTracker.hasConnection()) {
                ClusterNodeCache.stop();
                this.LOGGER.debug("heartBeat thread stop");
                break;
            }
            this.LOGGER.debug("heartBeat thread start time: " + new Date(System.currentTimeMillis()));
            ClusterHeartBeatFailureMaster.getInstance().run();
            ClusterHeartBeatMaster.getInstance().run();
            ClusterHeartBeatFailureCluster.getInstance().run();
            try {
                Thread.sleep(this.periodTime.get());
            }
            catch (InterruptedException e) {
                this.LOGGER.debug(e.getStackTrace());
            }
        }
    }

    public void updateDetection() {
        if (this.detection) {
            return;
        }
        this.detection = true;
    }

    public void initPeriodTime() {
        this.periodTime.set(this.defaultInterval);
    }

    public Set<Properties> getProperties(HostSpec hostSpec) {
        return CLUSTER_PROPERTIES.computeIfAbsent(hostSpec, k -> new HashSet());
    }

    public Map<HostSpec, Set<HostSpec>> getClusterRelationship() {
        return ClusterHeartBeatMaster.getInstance().getClusterRelationship();
    }

    public void addNodeRelationship(HostSpec key, HostSpec[] value, Properties properties) {
        String timeout;
        this.addClusterNode(key, value);
        this.addProperties(key, Collections.singleton(properties));
        if (PGProperty.HEARTBEAT_PERIOD.get(properties) != null) {
            String period = PGProperty.HEARTBEAT_PERIOD.get(properties);
            long time = Long.parseLong(period);
            this.periodTime.set(Math.min(this.periodTime.get(), time));
        }
        if (!ClusterNodeCache.isNumeric(timeout = PGProperty.MASTER_FAILURE_HEARTBEAT_TIMEOUT.get(properties))) {
            this.LOGGER.debug("Invalid heartbeatPeriod value: " + timeout);
            timeout = "30000";
        }
        ClusterHeartBeatFailureCluster.getInstance().setThresholdValue((int)(Long.parseLong(timeout) / this.periodTime.get()));
    }

    public void addProperties(HostSpec hostSpec, Set<Properties> properties) {
        Set<Properties> propertiesSet = CLUSTER_PROPERTIES.get(hostSpec);
        if (propertiesSet == null) {
            propertiesSet = new HashSet<Properties>();
        }
        propertiesSet.addAll(properties);
        CLUSTER_PROPERTIES.put(hostSpec, propertiesSet);
    }

    public void removeClusterNode(HostSpec key, HostSpec newKey, Set<HostSpec> slaves) {
        ClusterHeartBeatMaster.getInstance().removeClusterNode(key, newKey, slaves);
    }

    public void addClusterNode(HostSpec hostSpecs, HostSpec ... value) {
        ClusterHeartBeatMaster.getInstance().addClusterNode(hostSpecs, value);
    }

    public Set<HostSpec> getClusterSalveNode(HostSpec hostSpec) {
        return ClusterHeartBeatMaster.getInstance().getClusterSalveNode(hostSpec);
    }

    public void removeProperties(HostSpec hostSpec, Properties properties) {
        Set propertiesSet = CLUSTER_PROPERTIES.getOrDefault(hostSpec, null);
        if (propertiesSet != null) {
            propertiesSet.remove(properties);
            CLUSTER_PROPERTIES.put(hostSpec, propertiesSet);
        }
    }

    public void clear() {
        this.detection = false;
        CLUSTER_PROPERTIES.clear();
        ClusterHeartBeatMaster.getInstance().clear();
        ClusterHeartBeatFailureMaster.getInstance().clear();
        ClusterHeartBeatFailureCluster.getInstance().clear();
    }

    public QueryExecutor getQueryExecutor(HostSpec hostSpec, Set<Properties> propSet) throws SQLException {
        Properties props = null;
        try {
            Iterator<Properties> iterator = propSet.iterator();
            if (iterator.hasNext()) {
                Properties properties;
                props = properties = iterator.next();
                SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(props);
                SslMode sslMode = SslMode.of(props);
                String user = props.getProperty("user", "");
                String database = props.getProperty("PGDBNAME", "");
                PGStream pgStream = this.FACTORY.tryConnect(user, database, props, socketFactory, hostSpec, sslMode);
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(pgStream, user, database, 1000, new Properties());
                queryExecutor.setClientEncoding(pgStream.getEncoding() != null ? pgStream.getEncoding().name() : "UTF8");
                return queryExecutor;
            }
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            if (PSQLState.CONNECTION_REJECTED.getState().equals(sqlState) || "28P01".equals(sqlState)) {
                this.LOGGER.error("node " + hostSpec + " is active, and connenction authentication fails.");
                this.removeProperties(hostSpec, props);
            }
            this.LOGGER.error("acquire QueryExecutor failure " + e.getMessage());
        }
        catch (IOException e) {
            this.LOGGER.error(e.getCause());
        }
        throw new SQLException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeRoleIsMaster(QueryExecutor queryExecutor) {
        try {
            boolean bl = this.FACTORY.isMaster(queryExecutor);
            return bl;
        }
        catch (IOException | SQLException e) {
            this.LOGGER.debug("Error obtaining node role " + e.getMessage());
            this.LOGGER.debug(e.getStackTrace());
            boolean bl = false;
            return bl;
        }
        finally {
            queryExecutor.close();
        }
    }

    public void cacheProcess(HostSpec hostSpec, Set<HostSpec> slaves, Set<Properties> props, Integer frequency) {
        HostSpec maseterNode = this.findMasterNode(slaves, props);
        this.removeClusterNode(hostSpec, maseterNode, slaves);
        if (maseterNode != null) {
            this.addProperties(maseterNode, props);
            ClusterHeartBeatFailureMaster.getInstance().addFailureMaster(hostSpec, maseterNode);
        } else {
            FailureCluster cluster = new FailureCluster(hostSpec, slaves, props, frequency);
            ClusterHeartBeatFailureCluster.getInstance().addFailureCluster(cluster);
        }
        GlobalConnectionTracker.closeConnectionOfCrash(hostSpec.toString());
    }

    public HostSpec findMasterNode(Set<HostSpec> hostSpecSet, Set<Properties> properties) {
        for (HostSpec hostSpec : hostSpecSet) {
            QueryExecutor queryExecutor = null;
            try {
                queryExecutor = this.getQueryExecutor(hostSpec, properties);
            }
            catch (SQLException e) {
                continue;
            }
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            queryExecutor.close();
            if (!isMaster) continue;
            return hostSpec;
        }
        return null;
    }
}

