/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.core;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import javax.net.SocketFactory;
import org.apache.seatunnel.shade.org.postgresql.core.Encoding;
import org.apache.seatunnel.shade.org.postgresql.core.EncodingPredictor;
import org.apache.seatunnel.shade.org.postgresql.core.PGBindException;
import org.apache.seatunnel.shade.org.postgresql.core.Utils;
import org.apache.seatunnel.shade.org.postgresql.core.VisibleBufferedInputStream;
import org.apache.seatunnel.shade.org.postgresql.util.GT;
import org.apache.seatunnel.shade.org.postgresql.util.HostSpec;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

public class PGStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec hostSpec;
    private final byte[] _int4buf;
    private final byte[] _int2buf;
    private Socket connection;
    private VisibleBufferedInputStream pg_input;
    private OutputStream pg_output;
    private byte[] streamBuffer;
    private Encoding encoding;
    private Writer encodingWriter;
    private final int MAX_PARAMS_NUM = 65535;

    public PGStream(SocketFactory socketFactory, HostSpec hostSpec, int timeout) throws IOException {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        Socket socket = socketFactory.createSocket();
        if (!socket.isConnected()) {
            InetSocketAddress address = hostSpec.shouldResolve() != false ? new InetSocketAddress(hostSpec.getHost(), hostSpec.getPort()) : InetSocketAddress.createUnresolved(hostSpec.getHost(), hostSpec.getPort());
            socket.connect(address, timeout);
        }
        this.changeSocket(socket);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        this._int2buf = new byte[2];
        this._int4buf = new byte[4];
    }

    @Deprecated
    public PGStream(SocketFactory socketFactory, HostSpec hostSpec) throws IOException {
        this(socketFactory, hostSpec, 0);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() throws IOException {
        if (this.pg_input.available() > 0) {
            return true;
        }
        int soTimeout = this.getNetworkTimeout();
        this.setNetworkTimeout(1);
        try {
            boolean bl = this.pg_input.peek() != -1;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.setNetworkTimeout(soTimeout);
        }
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.pg_input = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encoding != null && this.encoding.name().equals(encoding.name())) {
            return;
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.pg_output){

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void sendChar(int val) throws IOException {
        this.pg_output.write(val);
    }

    public void sendInteger4(int val) throws IOException {
        this._int4buf[0] = (byte)(val >>> 24);
        this._int4buf[1] = (byte)(val >>> 16);
        this._int4buf[2] = (byte)(val >>> 8);
        this._int4buf[3] = (byte)val;
        this.pg_output.write(this._int4buf);
    }

    public void sendInteger2(int val) throws IOException {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("Tried to send an out-of-range integer as a 2-byte unsigned int value: " + val);
        }
        this._int2buf[0] = (byte)(val >>> 8);
        this._int2buf[1] = (byte)val;
        this.pg_output.write(this._int2buf);
    }

    public void send(byte[] buf) throws IOException {
        this.pg_output.write(buf);
    }

    public void send(byte[] buf, int siz) throws IOException {
        this.send(buf, 0, siz);
    }

    public void send(byte[] buf, int off, int siz) throws IOException {
        int bufamt = buf.length - off;
        this.pg_output.write(buf, off, bufamt < siz ? bufamt : siz);
        for (int i = bufamt; i < siz; ++i) {
            this.pg_output.write(0);
        }
    }

    public int peekChar() throws IOException {
        int c = this.pg_input.peek();
        if (c < 0) {
            throw new EOFException("EOF Exception");
        }
        return c;
    }

    public int receiveChar() throws IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            throw new EOFException("EOF Exception");
        }
        return c;
    }

    public int receiveInteger4() throws IOException {
        if (this.pg_input.read(this._int4buf) != 4) {
            throw new EOFException("EOF Exception");
        }
        return (this._int4buf[0] & 0xFF) << 24 | (this._int4buf[1] & 0xFF) << 16 | (this._int4buf[2] & 0xFF) << 8 | this._int4buf[3] & 0xFF;
    }

    public int receiveInteger2() throws IOException {
        if (this.pg_input.read(this._int2buf) != 2) {
            throw new EOFException("EOF Exception");
        }
        return (this._int2buf[0] & 0xFF) << 8 | this._int2buf[1] & 0xFF;
    }

    public String receiveString(int len) throws IOException {
        if (!this.pg_input.ensureBytes(len)) {
            throw new EOFException("EOF Exception");
        }
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
        this.pg_input.skip(len);
        return res;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int len) throws IOException {
        EncodingPredictor.DecodeResult res;
        block3: {
            if (!this.pg_input.ensureBytes(len)) {
                throw new EOFException("EOF Exception");
            }
            try {
                String value = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, null);
            }
            catch (IOException e) {
                res = EncodingPredictor.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
                if (res != null) break block3;
                Encoding enc = Encoding.defaultEncoding();
                String value = enc.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, enc.name());
            }
        }
        this.pg_input.skip(len);
        return res;
    }

    public String receiveString() throws IOException {
        int len = this.pg_input.scanCStringLength();
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len - 1);
        this.pg_input.skip(len);
        return res;
    }

    public byte[][] receiveTupleV3() throws IOException, OutOfMemoryError {
        int l_msgSize = this.receiveInteger4();
        int l_nf = this.receiveInteger2();
        byte[][] answer = new byte[l_nf][];
        OutOfMemoryError oom = null;
        for (int i = 0; i < l_nf; ++i) {
            int l_size = this.receiveInteger4();
            if (l_size == -1) continue;
            try {
                answer[i] = new byte[l_size];
                this.receive(answer[i], 0, l_size);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.skip(l_size);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[] receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.receive(answer, 0, siz);
        return answer;
    }

    public void receive(byte[] buf, int off, int siz) throws IOException {
        int w;
        for (int s = 0; s < siz; s += w) {
            w = this.pg_input.read(buf, off + s, siz - s);
            if (w >= 0) continue;
            throw new EOFException("EOF Exception");
        }
    }

    public void skip(int size) throws IOException {
        for (long s = 0L; s < (long)size; s += this.pg_input.skip((long)size - s)) {
        }
    }

    public void sendStream(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            int readCount;
            int count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
            try {
                readCount = inStream.read(this.streamBuffer, 0, count);
                if (readCount < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", expectedLength, expectedLength - remaining));
                }
            }
            catch (IOException ioe) {
                while (remaining > 0) {
                    this.send(this.streamBuffer, count);
                    count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                }
                throw new PGBindException(ioe);
            }
            this.send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pg_output.flush();
    }

    public void receiveEOF() throws SQLException, IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            return;
        }
        throw new PSQLException(GT.tr("Expected an EOF from server, got: {0}", c), PSQLState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }

    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.connection.setSoTimeout(milliseconds);
    }

    public int getNetworkTimeout() throws IOException {
        return this.connection.getSoTimeout();
    }

    private static String getSocketAddressDescStr(SocketAddress address) {
        String strAddress = "af_unix";
        if (address != null) {
            strAddress = address.toString().substring(1);
        }
        return strAddress;
    }

    public String getConnectInfo() {
        String clientSocketAddress = PGStream.getSocketAddressDescStr(this.connection.getLocalSocketAddress());
        String serverSocketAddress = PGStream.getSocketAddressDescStr(this.connection.getRemoteSocketAddress());
        return clientSocketAddress + "/" + serverSocketAddress;
    }

    public String getInputBufferByHex() {
        try {
            int bufferSize = this.pg_input.available();
            if (bufferSize <= 0) {
                return "buffer is empty";
            }
            byte[] bytes = new byte[bufferSize];
            this.pg_input.read(bytes);
            return Utils.toHexString(bytes);
        }
        catch (Exception e) {
            return "exception happens";
        }
    }

    public String getSocketStatus() {
        StringBuilder status = new StringBuilder();
        if (this.connection.isClosed()) {
            status.append("socket is closed; ");
        } else {
            status.append("socket is not closed; ");
        }
        try {
            this.getSocket().sendUrgentData(1);
            status.append("Urgent packet sent to backend successfully; ");
        }
        catch (IOException e) {
            status.append("Sending Urgent packet failed, detail: " + e.getMessage() + ". ");
        }
        return status.toString();
    }
}

