/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgConnection;
import org.apache.seatunnel.shade.org.postgresql.jdbc.PgStatement;
import org.apache.seatunnel.shade.org.postgresql.util.JdbcBlackHole;

public class ClientLogicImpl {
    private long m_handle = 0L;
    private PgConnection m_jdbcConn = null;

    private native Object[] linkClientLogicImpl(String var1);

    private native Object[] runQueryPreProcessImpl(long var1, String var3);

    private native Object[] runQueryPostProcessImpl(long var1);

    private native Object[] runClientLogicImpl(long var1, String var3, int var4);

    private native Object[] prepareQueryImpl(long var1, String var3, String var4, int var5);

    private native Object[] replaceStatementParamsImpl(long var1, String var3, String[] var4);

    private native Object[] replaceErrorMessageImpl(long var1, String var3);

    private native void destroy(long var1);

    public Object[] linkClientLogic(String databaseName, PgConnection jdbcConn) {
        if (this.m_handle == 0L && this.m_jdbcConn == null) {
            this.m_jdbcConn = jdbcConn;
            return this.linkClientLogicImpl(databaseName);
        }
        return new Object[0];
    }

    public Object[] runQueryPreProcess(String originalQuery) {
        return this.runQueryPreProcessImpl(this.m_handle, originalQuery);
    }

    public Object[] runClientLogic(String processData, int dataType) {
        return this.runClientLogicImpl(this.m_handle, processData, dataType);
    }

    public Object[] runQueryPostProcess() {
        return this.runQueryPostProcessImpl(this.m_handle);
    }

    public Object[] prepareQuery(String query, String statement_name, int parameter_count) {
        return this.prepareQueryImpl(this.m_handle, query, statement_name, parameter_count);
    }

    public Object[] replaceStatementParams(String statementName, String[] paramValues) {
        return this.replaceStatementParamsImpl(this.m_handle, statementName, paramValues);
    }

    public Object[] replaceErrorMessage(String originalMessage) {
        return this.replaceErrorMessageImpl(this.m_handle, originalMessage);
    }

    protected void close() {
        if (this.m_handle > 0L) {
            this.destroy(this.m_handle);
        }
        this.m_handle = 0L;
    }

    protected void finalize() {
        this.close();
    }

    public void setHandle(long handle) {
        this.m_handle = handle;
    }

    public long getHandle() {
        return this.m_handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetchDataFromQuery(String query) {
        PgStatement st = null;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("");
        try {
            st = (PgStatement)this.m_jdbcConn.createStatement();
            ResultSet rs = st.executeQueryWithNoCL(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnsCount = rsmd.getColumnCount();
            ArrayList<String> headers = new ArrayList<String>();
            for (int colIndex = 0; colIndex < columnsCount; ++colIndex) {
                headers.add(rsmd.getColumnName(colIndex + 1));
            }
            data.add(headers.toArray());
            while (rs.next()) {
                ArrayList<String> record = new ArrayList<String>();
                for (int colIndex = 1; colIndex < columnsCount + 1; ++colIndex) {
                    String colValue = rs.getString(colIndex);
                    if (colValue == null) {
                        colValue = "";
                    }
                    record.add(colValue);
                }
                data.add(record.toArray());
            }
            st.close();
        }
        catch (SQLException e) {
            Object[] objectArray;
            try {
                ArrayList<String> errorResponse = new ArrayList<String>();
                errorResponse.add(e.getMessage());
                objectArray = errorResponse.toArray();
            }
            catch (Throwable throwable) {
                JdbcBlackHole.close(st);
                throw throwable;
            }
            JdbcBlackHole.close(st);
            return objectArray;
        }
        JdbcBlackHole.close(st);
        return data.toArray();
    }

    static {
        System.loadLibrary("gauss_cl_jni");
    }
}

