/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.mysql.MySqlTypeConverter;

public class MySqlTypeMapper
implements JdbcDialectTypeMapper {
    private MySqlTypeConverter typeConverter;

    public MySqlTypeMapper() {
        this(MySqlTypeConverter.DEFAULT_INSTANCE);
    }

    public MySqlTypeMapper(MySqlTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public Column mappingColumn(BasicTypeDefine typeDefine) {
        return this.typeConverter.convert(typeDefine);
    }

    @Override
    public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String nativeType;
        String columnName = metadata.getColumnLabel(colIndex);
        String columnType = nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        if (Arrays.asList("CHAR", "VARCHAR", "ENUM").contains(nativeType)) {
            long octetLength = TypeDefineUtils.charTo4ByteLength(Long.valueOf(precision));
            precision = (int)Math.max((long)precision, octetLength);
        }
        if ("tinyint".equalsIgnoreCase(nativeType) && precision == 1) {
            columnType = "tinyint(1)";
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(columnType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine);
    }
}

