/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.module.pay.enums.transfer;

import java.util.Objects;
import lombok.Generated;

public enum PayTransferStatusEnum {
    WAITING(0, "\u7b49\u5f85\u8f6c\u8d26"),
    PROCESSING(5, "\u8f6c\u8d26\u8fdb\u884c\u4e2d"),
    SUCCESS(10, "\u8f6c\u8d26\u6210\u529f"),
    CLOSED(20, "\u8f6c\u8d26\u5173\u95ed");

    private final Integer status;
    private final String name;

    public static boolean isSuccess(Integer n) {
        return Objects.equals(n, SUCCESS.getStatus());
    }

    public static boolean isClosed(Integer n) {
        return Objects.equals(n, CLOSED.getStatus());
    }

    public static boolean isWaiting(Integer n) {
        return Objects.equals(n, WAITING.getStatus());
    }

    public static boolean isProgressing(Integer n) {
        return Objects.equals(n, PROCESSING.getStatus());
    }

    public static boolean isWaitingOrProcessing(Integer n) {
        return PayTransferStatusEnum.isWaiting(n) || PayTransferStatusEnum.isProgressing(n);
    }

    public static boolean isSuccessOrClosed(Integer n) {
        return PayTransferStatusEnum.isSuccess(n) || PayTransferStatusEnum.isClosed(n);
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private PayTransferStatusEnum(Integer n2, String string2) {
        this.status = n2;
        this.name = string2;
    }
}

