package com.cloudt.observation.api.rpc.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>
 * 业务操作日志表
 * </p>
 *
 * @author nc
 * @since 2023-12-07
 */
@ApiModel(value = "ObservationOperationLog对象", description = "业务操作日志表")
@Data
public class ObservationOperationLogParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty("应用标识 （非必填，默认：取值spring.application.name，微服务工程名）")
    private String appName;

    @ApiModelProperty("操作页面编码（非必填，默认：取值http request head获取请求）")
    private String menuCode;

    @ApiModelProperty("唯一业务类型（必填），业务对象名称，开发指定，规范：业务对象的名称应直观地描述其作用或所代表的实体，业务对象对应实体的DO名称 如：SysPlatformUdcDO，SysPlatformMenusDO")
    private String businessType;

    @ApiModelProperty("唯一业务参数（必填），重要参数：产品或开发需求文档上标注，如：订单编号，员工编号。 用于操作日志查询）")
    private String businessParam;

    @ApiModelProperty("操作类型，必填：使用OperationTypeEnum枚举 必填（枚举：创建，编辑，删除，审批，导出，导入，查询，其他）")
    private String operationType;

    @ApiModelProperty("操作类型名称，默认：使用操作类型枚举名称，如果是其他类型，必填")
    private String operationTypeName;

    @ApiModelProperty("操作描述（必填），操作主数据记录")
    private String operationDescription;

    @ApiModelProperty("操作前数据存储（非必填）")
    private String operationBeforeData;

    @ApiModelProperty("操作后数据存储（非必填）")
    private String operationAfterData;

    @ApiModelProperty("操作时间（必填）默认：当前时间")
    private String operationTime;

    @ApiModelProperty("操作人名称（非必填）默认：当前登录操作人")
    private String operationUserName;

    @ApiModelProperty("操作人ID（非必填）默认：当前登录操作人")
    private Long operationUserId;

    @ApiModelProperty("操作请求地址 （非必填）默认：通过HTTP REQUEST获取地址")
    private String requestUrl;

    @ApiModelProperty("租户ID：默认：当前操作人租户")
    private Long tenantId;

    @ApiModelProperty("请求方式（非必填）默认：通过HTTP REQUEST获取")
    private String requestMethod;

    @ApiModelProperty("操作IP （非必填）默认：当前请求IP")
    private String operationIp;

    @ApiModelProperty("是否成功（必填） 默认：false")
    private Boolean success;

    @ApiModelProperty("失败描述，成功非必填，失败必填")
    private String exceptionDesc;

}
