package com.cloudt.observation.api.rpc.param;

import com.elitescloud.cloudt.common.base.param.QueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.08.22
 **/

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SearchAccessLog", description = "SearchAccessLog")
public class SearchAccessLogParamDto extends QueryParam {

    @ApiModelProperty("请求用户Id")
    private Long userId;

    @ApiModelProperty("请求用户名")
    private String username;


    @ApiModelProperty("请求时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime requestTimeStart;
    @ApiModelProperty("请求时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime requestTimeEnd;


    @ApiModelProperty("访问耗时，毫秒")
    private Long costStart;
    private Long costEnd;

    @ApiModelProperty("请求路径")
    private String uri;

    @ApiModelProperty("请求接口名称，默认swagger注解获取")
    private String operation;

    @ApiModelProperty("服务端应用编码，如cloudt-system")
    private String appCode;

    @ApiModelProperty("请求端IP")
    private String reqIp;

    @ApiModelProperty("请求端外网IP")
    private String reqOuterIp;
    @ApiModelProperty("状态码")
    private Integer resultCode;

    @ApiModelProperty("是否请求成功")
    private Boolean success;


    private String traceId;


}
