package com.cloudt.observation.api.rpc.vo;

import com.cloudt.observation.core.common.log.dto.BaseRequestLogDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 接口访问日志实体.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "AccessLogVO", description = "AccessLogVO")
public class AccessLogVoDto extends BaseRequestLogDO implements Serializable {
    private static final long serialVersionUID = -56469281719800877L;

    @ApiModelProperty("traceId")
    private String traceId;

    @ApiModelProperty("threadId")
    private String threadId;

    @ApiModelProperty("responseBodyTxt")
    private String responseBodyTxt;
}
