package com.cloudt.observation.api.rpc.service;


import com.cloudt.observation.api.rpc.Application;
import com.cloudt.observation.api.rpc.param.SearchAccessLogParamDto;
import com.cloudt.observation.api.rpc.vo.AccessLogVoDto;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

import java.net.URI;

/**
 * @author : chen.niu
 * @description : 系统日志远程调用接口。
 * @date : 2023/5/4 10:14
 */
@FeignClient(name = Application.NAME, path = ISysLogService.URI)
@Validated
public interface ISysLogService {
      String URI = Application.URI_PREFIX+"/log" ;
      /**
       * 访问日志检索查询
       * @param searchAccessLog 访问日志检索查询对象
       * @return 返回访问日志数据
       */
      @PostMapping(value = "/listByAreaCodes")
      ApiResult<PagingVO<AccessLogVoDto>> searchAccessLog(SearchAccessLogParamDto searchAccessLog);
}
