package com.cloudt.observation.api.rpc.service;

import com.cloudt.observation.api.rpc.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 操作日志接口
 * @date : 2023-12-07 16:49
 */
@FeignClient(name = Application.NAME, path = IObservationOperationLogService.URI)
@Validated
public interface IObservationOperationLogService {
    String URI = Application.URI_PREFIX+"/observationOperationLog" ;
    @PostMapping("/queryObservationOperationLog")
    ApiResult<PagingVO<ArrayList<HashMap<String,Object>>>> queryObservationOperationLog(Map<String,Object> map) ;
}
