package com.elitescloud.cloudt.authorization.api.client.client;

import com.elitescloud.cloudt.common.constant.Terminal;

import java.util.Map;

/**
 * 用户认证服务.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/23
 */
public interface OAuthUserProvider {

    /**
     * 认证用户
     *
     * @param requestParam 用户请求的参数
     * @return 是否认证通过
     */
    boolean authenticate(Map<String, String> requestParam);

    /**
     * 获取认证的用户
     *
     * @return 用户名
     */
    default String obtainUser() {
        return null;
    }

    /**
     * 使用终端
     *
     * @return 终端
     */
    default Terminal terminal() {
        return Terminal.BACKEND;
    }
}
