package com.elitescloud.cloudt.authorization.api.client.common;

import com.elitescloud.cloudt.common.base.ApiCode;
import org.springframework.security.core.AuthenticationException;

/**
 * 自定义认证异常.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/09
 */
public class AuthorizationException extends AuthenticationException {
    private static final long serialVersionUID = -8349296705929335536L;

    private ApiCode apiCode;

    public AuthorizationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public AuthorizationException(String msg) {
        super(msg);
    }

    public AuthorizationException(ApiCode apiCode, String msg, Throwable cause) {
        super(msg, cause);
        this.apiCode = apiCode;
    }

    public ApiCode getApiCode() {
        return apiCode == null ? ApiCode.LOGIN_EXCEPTION : apiCode;
    }
}
