package com.elitescloud.cloudt.authorization.api.client.common;

import com.elitescloud.cloudt.authorization.api.client.client.common.OAuthClientConstant;

import java.io.Serializable;

/**
 * 自定义登录类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/26
 */
public class LoginType implements Serializable {
    private static final long serialVersionUID = 56733913036762215L;

    /**
     * 用户名与密码
     */
    public static final LoginType PASSWORD = new LoginType("password");
    /**
     * 手机号与密码
     */
    public static final LoginType MOBILE_PWD = new LoginType("mobile_pwd");
    /**
     * 账号（通用，用户名或手机号）与密码
     */
    public static final LoginType ACCOUNT_PWD = new LoginType("account_pwd");
    /**
     * 手机号与短信验证码
     */
    public static final LoginType MOBILE_SMS = new LoginType("mobile_sms");
    /**
     * 邮箱与验证码
     */
    public static final LoginType EMAIL_CODE = new LoginType("email_code");
    /**
     * 微信小程序
     */
    public static final LoginType WX_MINAPP = new LoginType("wx_minapp");
    /**
     * 内部认证
     */
    public static final LoginType INTERNAL = new LoginType("internal");
    /**
     * 客户端用户（虚拟用户）
     */
    public static final LoginType CLIENT_USER = new LoginType(OAuthClientConstant.SSO_GRANT_TYPE);

    private final String type;

    public LoginType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LoginType) {
            LoginType loginType = (LoginType) o;
            if (loginType.getType() == null) {
                return getType() == null;
            }
            return loginType.getType().equals(getType());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public String toString() {
        return getType();
    }
}
