package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.context.CloudtContextAutoConfiguration;
import com.elitescloud.cloudt.context.threadpool.support.ContextTransfer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * CloudT认证自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/6
 */
@ConditionalOnClass({CloudtContextAutoConfiguration.class})
public class CloudtAuthorizationAutoConfiguration {

    /**
     * 用户认证信息上下文传递器
     *
     * @return 上下文传递器
     */
    @Bean
    ContextTransfer<SecurityContext> contextTransferSecurityContext() {
        return new ContextTransfer<>() {
            @Override
            public SecurityContext getContext() {
                return SecurityContextHolder.getContext();
            }

            @Override
            public void setContext(SecurityContext context) {
                SecurityContextHolder.setContext(context);
            }

            @Override
            public void clearContext() {
                SecurityContextHolder.clearContext();
            }
        };
    }
}
