package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.RedisAuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.common.config.cache.RedisCacheAutoConfiguration;
import com.elitescloud.cloudt.common.util.RedisUtils;
import com.elitescloud.cloudt.context.redis.RedisWrapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
@AutoConfigureAfter(RedisCacheAutoConfiguration.class)
@ConditionalOnBean(RedisUtils.class)
public class CloudtAuthorizationCacheAutoConfiguration {

    private final RedisUtils redisUtils;

    public CloudtAuthorizationCacheAutoConfiguration(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }

    /**
     * redis操作工具
     *
     * @return
     */
    @Bean
    @ConditionalOnMissingBean
    RedisHelper redisHelper(ObjectProvider<RedisWrapper> wrapperObjectProvider) {
        return new RedisHelper(redisUtils, wrapperObjectProvider.getIfAvailable());
    }

    /**
     * 身份缓存服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    @ConditionalOnMissingBean
    AuthenticationCache defaultAuthenticationCache(RedisHelper redisHelper) {
        return new RedisAuthenticationCache(redisHelper);
    }
}
