package com.elitescloud.cloudt.authorization.api.client.config.security;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * single认证方式的客户端security配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@Log4j2
@ConditionalOnProperty(prefix = AuthorizationProperties.CONFIG_PREFIX, name = "type", havingValue = "client")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class SingleClientServletSecurityConfig extends AbstractServletSecurityConfig {

    @Bean(SECURITY_CHAIN_DEFAULT)
    @ConditionalOnMissingBean(name = SECURITY_CHAIN_DEFAULT)
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        super.defaultSecurityConfig(http);

        return http.build();
    }
}
