package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 未认证用户的处理.
 * <p>
 * 对于401类的未认证用户处理
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/27
 */
@Log4j2
public class DefaultAuthenticationEntryPointHandler extends AbstractHandler implements AuthenticationEntryPoint {

    private final String loginPage;

    public DefaultAuthenticationEntryPointHandler(String loginPage) {
        this.loginPage = loginPage;
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info("请求资源[{}]失败，需要先认证！", request.getRequestURI());
        if (StringUtils.hasText(loginPage) && supportRedirect(request)) {
            // 支持重定向，则重定向至登录页
            sendRedirect(request, response, loginPage);
            return;
        }

        // 不支持重定向，则返回401错误
        var result = ApiResult.fail(ApiCode.UNAUTHORIZED);

        writeResponse(response, result, HttpStatus.UNAUTHORIZED);
    }
}
