package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.CollectionUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 认证相关处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
public class DelegateAuthenticationCallable implements AuthenticationCallable {

    private final List<AuthenticationCallable> authenticationCallables;

    public DelegateAuthenticationCallable(List<AuthenticationCallable> authenticationCallables) {
        this.authenticationCallables = authenticationCallables;
    }

    public static DelegateAuthenticationCallable getInstance(ObjectProvider<AuthenticationCallable> objectProvider) {
        return new DelegateAuthenticationCallable(objectProvider.stream().collect(Collectors.toList()));
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(authenticationCallables)) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : authenticationCallables) {
            authenticationCallable.onLogin(request, response, token, authentication);
        }
    }

    @Override
    public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        if (CollectionUtils.isEmpty(authenticationCallables)) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : authenticationCallables) {
            authenticationCallable.onLoginFailure(request, response, exception);
        }
    }

    @Override
    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (CollectionUtils.isEmpty(authenticationCallables)) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : authenticationCallables) {
            authenticationCallable.onLogout(request, response, token, principal);
        }
    }
}
