package com.elitescloud.cloudt.authorization.api.client.principal;

import cn.hutool.core.util.ObjectUtil;
import lombok.Data;
import lombok.Getter;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * 认证过的客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/6
 */
@Getter
public class AuthorizedClient implements Serializable {
    private static final long serialVersionUID = -2450603428618865616L;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 授权范围
     */
    private List<String> scopes;

    @SuppressWarnings("unchecked")
    public static AuthorizedClient buildByJwt(Jwt jwt) {
        AuthorizedClient authorizedClient = new AuthorizedClient();

        var audience = jwt.getAudience();
        if (!CollectionUtils.isEmpty(audience)) {
            authorizedClient.setClientId(audience.get(0));
        }

        var scopes = jwt.getClaimAsStringList("scope");
        authorizedClient.setScopes(ObjectUtil.defaultIfNull(scopes, Collections.emptyList()));

        return authorizedClient;
    }

    private void setClientId(String clientId) {
        this.clientId = clientId;
    }

    private void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }
}

