/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.client.config;

import com.elitescloud.cloudt.authorization.api.client.client.OAuthUserProvider;
import com.elitescloud.cloudt.authorization.api.client.client.config.OAuthClientProperties;
import com.elitescloud.cloudt.authorization.api.client.client.config.filter.OAuthClientTokenFilter;
import com.elitescloud.cloudt.authorization.api.client.client.service.AuthServerRequestHolder;
import com.elitescloud.cloudt.authorization.api.client.client.service.OAuthClientUserService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@ConditionalOnProperty(prefix="elitesland.authorization.client-user", name={"enabled"}, havingValue="true")
@ConditionalOnClass(value={WebClient.class, HttpClient.class})
@EnableConfigurationProperties(value={OAuthClientProperties.class})
public class OAuthClientAutoConfiguration {
    @Value(value="${spring.security.oauth2.resourceserver.jwt.issuer-uri:#{null}}")
    private String serverUri;
    private final OAuthClientProperties clientProperties;

    public OAuthClientAutoConfiguration(OAuthClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        Assert.hasText((String)this.serverUri, (String)"issuerUri\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Bean
    public OAuthClientUserService oauthClientUserService(ObjectProvider<OAuthUserProvider> userServiceObjectProvider, ObjectMapper objectMapper) {
        OAuthUserProvider userProvider = (OAuthUserProvider)userServiceObjectProvider.getIfUnique();
        Assert.notNull((Object)userProvider, (String)"\u8bf7\u914d\u7f6e\u7528\u6237\u670d\u52a1\uff1aOAuthUserProvider");
        AuthServerRequestHolder authServerRequestHolder = new AuthServerRequestHolder(this.clientProperties, this.serverUri, objectMapper);
        return new OAuthClientUserService(this.clientProperties, userProvider, objectMapper, authServerRequestHolder);
    }

    @Bean
    public OAuthClientTokenFilter oauthClientTokenFilter(OAuthClientUserService userService) {
        Assert.hasText((String)this.clientProperties.getPath(), (String)"token\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        return new OAuthClientTokenFilter(this.clientProperties, userService);
    }
}

