/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.client.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.client.config.OAuthClientProperties;
import com.elitescloud.cloudt.authorization.core.AuthorizationUtil;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Decoder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class AuthServerRequestHolder {
    private static final Logger log = LogManager.getLogger(AuthServerRequestHolder.class);
    private final OAuthClientProperties oauthClientProperties;
    private final ObjectMapper objectMapper;
    private static final String AUTH_SERVER_METADATA_URI = "/.well-known/oauth-authorization-server";
    private Map<String, Object> authServerMetadata = Collections.emptyMap();
    private WebClient webClient;

    public AuthServerRequestHolder(OAuthClientProperties oauthClientProperties, String serverUri, ObjectMapper objectMapper) {
        this.oauthClientProperties = oauthClientProperties;
        this.objectMapper = objectMapper;
        this.init(serverUri);
    }

    public Mono<ApiResult<OAuthToken>> getAccessToken(String username, Terminal terminal) {
        Mono<String> urlOptional = this.getTokenUriOfMetadata();
        LinkedMultiValueMap requestEntity = new LinkedMultiValueMap();
        requestEntity.add((Object)"grant_type", (Object)"client_user");
        requestEntity.add((Object)"username", (Object)username);
        requestEntity.add((Object)"scope", (Object)"all");
        requestEntity.add((Object)"terminal", (Object)terminal.name());
        String url = (String)urlOptional.block();
        if (CharSequenceUtil.isBlank((CharSequence)url)) {
            return Mono.just((Object)ApiResult.fail((String)"\u6388\u6743\u670d\u52a1\u5f02\u5e38\uff0c\u83b7\u53d6\u6388\u6743\u63a5\u53e3\u8def\u5f84\u5931\u8d25\uff01"));
        }
        String clientAuth = null;
        try {
            clientAuth = AuthorizationUtil.encodeBasicAuth("client_business", "123456");
        }
        catch (IOException e2) {
            return Mono.just((Object)ApiResult.fail((String)"\u6388\u6743\u670d\u52a1\u5f02\u5e38"));
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(url, new Object[0])).header("Authorization", new String[]{clientAuth})).bodyValue((Object)requestEntity).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<ApiResult<OAuthToken>>(){}).doOnError(throwable -> log.error("\u8c03\u7528\u6388\u6743\u670d\u52a1\u5668\u751f\u6210token\u5f02\u5e38\uff1a", throwable)).onErrorResume(Throwable.class, e -> Mono.just((Object)ApiResult.fail((String)"\u8ba4\u8bc1\u6388\u6743\u5931\u8d25")));
    }

    private void init(String serverUri) {
        log.info("\u521d\u59cb\u5316OAuth\u670d\u52a1\u8ba4\u8bc1\u5ba2\u6237\u7aef\uff0c\u670d\u52a1\u5668\u7aef\u5730\u5740\uff1a{}", (Object)Assert.notBlank((CharSequence)serverUri, (String)"\u672a\u77e5OAuth\u670d\u52a1\u7aef\u5730\u5740", (Object[])new Object[0]));
        this.createWebClient(serverUri);
        CompletableFuture.runAsync(() -> this.queryAuthServerMetadata().block());
    }

    private void createWebClient(String serverUri) {
        HttpClient httpClient = HttpClient.create().baseUrl(serverUri).responseTimeout(Objects.requireNonNullElse(this.oauthClientProperties.getReadTimeout(), Duration.ofSeconds(30L)));
        ReactorClientHttpConnector httpConnector = new ReactorClientHttpConnector(httpClient);
        this.webClient = WebClient.builder().clientConnector((ClientHttpConnector)httpConnector).codecs(codec -> codec.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.objectMapper, new MimeType[0]))).build();
    }

    private Mono<Map<String, Object>> queryAuthServerMetadata() {
        return this.webClient.get().uri(AUTH_SERVER_METADATA_URI, new Object[0]).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}).doOnError(throwable -> log.error("\u67e5\u8be2OAuth\u670d\u52a1\u5143\u6570\u636e\u5931\u8d25\uff1a", throwable)).doOnNext(data -> {
            this.authServerMetadata = data;
        });
    }

    private Mono<String> getTokenUriOfMetadata() {
        String key = "token_endpoint";
        if (!this.authServerMetadata.isEmpty()) {
            String uri = (String)this.authServerMetadata.get(key);
            return uri == null ? Mono.empty() : Mono.just((Object)uri);
        }
        return this.queryAuthServerMetadata().filter(t -> !t.isEmpty() && t.containsKey(key)).map(t -> (String)t.get(key));
    }
}

