/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.OAuth2ResourceServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.SingleClientServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.support.dubbo.SecurityDubboConfig;
import com.elitescloud.cloudt.authorization.api.client.config.support.springcloud.SecuritySpringCloudConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;

@EnableConfigurationProperties(value={AuthorizationProperties.class})
@Import(value={OnEnableSecurity.class, OnDisableSecurity.class})
public class AuthorizationClientAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationClientAutoConfiguration.class);

    @Bean
    public PasswordEncoder passwordEncoder() {
        DelegatingPasswordEncoder encoder = (DelegatingPasswordEncoder)PasswordEncoderFactories.createDelegatingPasswordEncoder();
        encoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)new BCryptPasswordEncoder());
        return encoder;
    }

    @ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="false")
    static class OnDisableSecurity {
        public OnDisableSecurity() {
            log.info("\u7981\u7528Security");
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
        @Order(value=-2147483648)
        public SecurityFilterChain defaultFilterChain(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll();
            return (SecurityFilterChain)http.build();
        }
    }

    @ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Import(value={SingleClientServletSecurityConfig.class, OAuth2ResourceServletSecurityConfig.class, SecuritySpringCloudConfig.class, SecurityDubboConfig.class})
    static class OnEnableSecurity {
        private final AuthorizationProperties authorizationProperties;

        public OnEnableSecurity(AuthorizationProperties authorizationProperties) {
            this.authorizationProperties = authorizationProperties;
            log.info("\u542f\u7528Security");
        }
    }
}

