/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.RedisAuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.common.base.inter.BaseCallbackWrapper;
import com.elitescloud.cloudt.common.config.cache.RedisCacheAutoConfiguration;
import com.elitescloud.cloudt.common.util.RedisUtils;
import com.elitescloud.cloudt.context.redis.RedisWrapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={RedisCacheAutoConfiguration.class})
@ConditionalOnBean(value={RedisUtils.class})
public class CloudtAuthorizationCacheAutoConfiguration {
    private final RedisUtils redisUtils;

    public CloudtAuthorizationCacheAutoConfiguration(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }

    @Bean
    @ConditionalOnMissingBean
    RedisHelper redisHelper(ObjectProvider<RedisWrapper> wrapperObjectProvider) {
        return new RedisHelper(this.redisUtils, (BaseCallbackWrapper)wrapperObjectProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    AuthenticationCache defaultAuthenticationCache(RedisHelper redisHelper) {
        return new RedisAuthenticationCache(redisHelper);
    }
}

