/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.configurer;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.AuthorizationConfigurerCustomizer;
import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter.AccessTokenRenewalFilter;
import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter.BearerTokenAuthenticationFilter;
import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.provider.BearerTokenAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationEntryPointHandler;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import javax.servlet.Filter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;

public class DefaultAuthorizationConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<DefaultAuthorizationConfigurer<H>, H> {
    private static final Logger log = LogManager.getLogger(DefaultAuthorizationConfigurer.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;
    private final ObjectProvider<AuthorizationConfigurerCustomizer> authorizationConfigurerCustomizer;
    private AuthenticationEntryPoint authenticationEntryPoint;
    private boolean needBearerTokenAuthenticationFilter = false;
    private boolean autoRenewalToken = false;

    public DefaultAuthorizationConfigurer(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache, ObjectProvider<AuthorizationConfigurerCustomizer> authorizationConfigurerCustomizer) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
        this.authorizationConfigurerCustomizer = authorizationConfigurerCustomizer;
    }

    public void init(H builder) throws Exception {
        Assert.notNull((Object)this.authorizationProperties, (String)"AuthorizationProperties\u4e3a\u7a7a");
        builder.setSharedObject(AuthorizationProperties.class, (Object)this.authorizationProperties);
        if (this.authorizationConfigurerCustomizer != null) {
            for (AuthorizationConfigurerCustomizer customizer : this.authorizationConfigurerCustomizer) {
                customizer.init(builder);
            }
        }
        super.init(builder);
    }

    public void configure(H builder) throws Exception {
        this.addBearerTokenAuthenticationFilter(builder);
        if (this.autoRenewalToken) {
            this.addAccessTokenRenewalFilter(builder);
        }
        if (this.authorizationConfigurerCustomizer != null) {
            for (AuthorizationConfigurerCustomizer customizer : this.authorizationConfigurerCustomizer) {
                customizer.configure(builder);
            }
        }
        super.configure(builder);
    }

    public DefaultAuthorizationConfigurer<H> needBearerTokenAuthenticationFilter(boolean needBearerTokenAuthenticationFilter) {
        this.needBearerTokenAuthenticationFilter = needBearerTokenAuthenticationFilter;
        return this;
    }

    public DefaultAuthorizationConfigurer<H> autoRenewalToken(boolean autoRenewalToken) {
        this.autoRenewalToken = autoRenewalToken;
        return this;
    }

    public DefaultAuthorizationConfigurer<H> authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
        return this;
    }

    private void addAccessTokenRenewalFilter(H http) {
        if (this.authenticationCache == null) {
            return;
        }
        AccessTokenRenewalFilter filter = new AccessTokenRenewalFilter(this.authorizationProperties, this.authenticationCache);
        http.addFilterAfter((Filter)filter, AuthorizationFilter.class);
    }

    private void addBearerTokenAuthenticationFilter(H http) {
        try {
            Class.forName("org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken");
            log.debug("\u5df2\u5b58\u5728BearerTokenAuthenticationFilter");
            if (!this.needBearerTokenAuthenticationFilter) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        BearerTokenAuthenticationFilter filter = new BearerTokenAuthenticationFilter(authenticationManager);
        if (this.authenticationEntryPoint == null) {
            this.authenticationEntryPoint = new DefaultAuthenticationEntryPointHandler(this.authorizationProperties.getLoginPage());
        }
        filter.setAuthenticationEntryPoint(this.authenticationEntryPoint);
        http.addFilterBefore((Filter)filter, BasicAuthenticationFilter.class);
        SecurityContextRepository securityContextRepository = (SecurityContextRepository)http.getSharedObject(SecurityContextRepository.class);
        if (securityContextRepository != null) {
            filter.setSecurityContextRepository(securityContextRepository);
        }
        BearerTokenAuthenticationProvider authenticationProvider = new BearerTokenAuthenticationProvider();
        http.authenticationProvider((AuthenticationProvider)this.postProcess(authenticationProvider));
    }
}

