/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.configurer.provider;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.common.InterceptUri;
import com.elitescloud.cloudt.authorization.api.client.common.SecurityConstants;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.principal.AuthorizedClient;
import com.elitescloud.cloudt.authorization.api.client.token.BearerTokenAuthenticationToken;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class BearerTokenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LogManager.getLogger(BearerTokenAuthenticationProvider.class);
    private static final Duration DEFAULT_MAX_CLOCK_SKEW = Duration.of(60L, ChronoUnit.SECONDS);
    private final Clock clock = Clock.systemUTC();
    private final List<RequestMatcher> allowRequestList = new ArrayList<RequestMatcher>();
    private AuthenticationCache authenticationCache;
    private JwtDecoder jwtDecoder;
    private AuthorizationProperties authorizationProperties;
    private HandlerMappingIntrospector handlerMappingIntrospector;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        BearerTokenAuthenticationToken authenticationToken = (BearerTokenAuthenticationToken)authentication;
        Jwt jwt = this.decodeToken(authenticationToken);
        String principalType = jwt.getClaimAsString("yst_pt");
        BearerTokenAuthenticationToken authorizationResult = new BearerTokenAuthenticationToken(authenticationToken.getToken(), Collections.emptyList());
        authorizationResult.setAuthorizedClient(AuthorizedClient.buildByJwt(jwt));
        if (CharSequenceUtil.equals((CharSequence)principalType, (CharSequence)"us")) {
            GeneralUserDetails user = this.authenticationCache.getUserDetail(authenticationToken.getToken());
            if (user == null) {
                if (this.allow()) {
                    return SecurityConstants.AUTHENTICATION_ANONYMOUS;
                }
                log.warn("\u65e0\u6548token\uff1a{}", (Object)authenticationToken.getToken());
                throw new AuthorizationException("\u5f53\u524d\u7528\u6237\u8fd8\u672a\u8ba4\u8bc1\u6216\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f");
            }
            authorizationResult.setPrincipal(user);
        } else {
            this.validateExpires(jwt);
        }
        return authorizationResult;
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private boolean allow() {
        if (this.authorizationProperties.getAnonymousEnabled().booleanValue()) {
            return true;
        }
        if (this.allowRequestList.isEmpty()) {
            this.initAllowRequestList();
        }
        if (this.allowRequestList.isEmpty()) {
            return false;
        }
        HttpServletRequest request = HttpServletUtil.currentRequest();
        for (RequestMatcher requestMatcher : this.allowRequestList) {
            if (!requestMatcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    private void initAllowRequestList() {
        HashSet<String> allowList = new HashSet<String>();
        if (this.authorizationProperties.getAllowList() != null) {
            allowList.addAll(this.authorizationProperties.getAllowList());
        }
        allowList.addAll(InterceptUri.getAllowUri());
        if (!allowList.isEmpty()) {
            HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)ObjectUtil.defaultIfNull((Object)this.handlerMappingIntrospector, (Object)new HandlerMappingIntrospector());
            for (String s : allowList) {
                if (this.adapterMvcRequestMatch(s)) {
                    this.allowRequestList.add((RequestMatcher)new MvcRequestMatcher(introspector, s));
                    continue;
                }
                this.allowRequestList.add((RequestMatcher)new AntPathRequestMatcher(s));
            }
        }
    }

    private boolean adapterMvcRequestMatch(String pattern) {
        if (pattern == null) {
            return false;
        }
        int indexDoubleWildcard = pattern.indexOf("**");
        return indexDoubleWildcard == pattern.length() - 2;
    }

    private Jwt decodeToken(BearerTokenAuthenticationToken bearer) {
        try {
            return this.jwtDecoder.decode(bearer.getToken());
        }
        catch (BadJwtException e) {
            log.error("\u89e3\u6790token\u5f02\u5e38\uff1a", (Throwable)e);
            throw new InvalidBearerTokenException("\u4e0d\u652f\u6301\u7684token", (Throwable)e);
        }
    }

    private void validateExpires(Jwt jwt) {
        Instant expiry = jwt.getExpiresAt();
        if (expiry != null && Instant.now(this.clock).minus(DEFAULT_MAX_CLOCK_SKEW).isAfter(expiry)) {
            throw new AuthorizationException("\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f");
        }
        Instant notBefore = jwt.getNotBefore();
        if (notBefore != null && Instant.now(this.clock).plus(DEFAULT_MAX_CLOCK_SKEW).isBefore(notBefore)) {
            throw new AuthorizationException("\u8eab\u4efd\u8ba4\u8bc1\u8fd8\u672a\u751f\u6548");
        }
    }

    private boolean renewal() {
        return this.authorizationProperties.getTokenRenewal() != null && this.authorizationProperties.getTokenRenewal().getSeconds() > 0L;
    }

    @Autowired
    public void setAuthenticationCache(AuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    @Autowired
    public void setJwtDecoder(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }

    @Autowired
    public void setAuthorizationProperties(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Autowired(required=false)
    @Lazy
    public void setHandlerMappingIntrospector(HandlerMappingIntrospector handlerMappingIntrospector) {
        this.handlerMappingIntrospector = handlerMappingIntrospector;
    }
}

