/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.tool;

import com.elitescloud.cloudt.common.base.inter.BaseCallbackWrapper;
import com.elitescloud.cloudt.common.util.RedisUtils;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.springframework.lang.Nullable;

public class RedisHelper {
    private final RedisUtils redisUtils;
    private BaseCallbackWrapper callbackWrapper = new DefaultRedisCallbackWrapper();

    public RedisHelper(@Nullable RedisUtils redisUtils, @Nullable BaseCallbackWrapper callbackWrapper) {
        this.redisUtils = redisUtils;
        if (callbackWrapper != null) {
            this.callbackWrapper = callbackWrapper;
        }
    }

    public <T> T execute(Function<RedisUtils, T> callable) {
        if (this.redisUtils == null) {
            throw new IllegalStateException("RedisUtil\u672a\u627e\u5230");
        }
        try {
            return (T)this.callbackWrapper.apply(() -> callable.apply(this.redisUtils), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Redis\u5f02\u5e38", e);
        }
    }

    private static class DefaultRedisCallbackWrapper
    implements BaseCallbackWrapper {
        private DefaultRedisCallbackWrapper() {
        }

        public Object apply(Callable callable, Object o) throws Exception {
            return callable.call();
        }
    }
}

