/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.util;

import com.elitescloud.cloudt.context.SpringContextHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HttpServletUtil {
    private static final Logger log = LogManager.getLogger(HttpServletUtil.class);
    private static final Object LOCK = new Object();
    private static final Map<Class<?>, Object> SHARED_OBJECTS = new HashMap();

    private HttpServletUtil() {
    }

    public static void writeJson(HttpServletResponse response, Object object) throws Exception {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        if (object instanceof String) {
            writer.write((String)object);
        } else {
            writer.write(HttpServletUtil.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object));
        }
        writer.flush();
        writer.close();
    }

    public static void writeJsonIgnoreException(HttpServletResponse response, Object object) {
        try {
            HttpServletUtil.writeJson(response, object);
        }
        catch (Exception e) {
            log.info("\u8fd4\u56de\u524d\u7aef\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static MultiValueMap<String, String> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> HttpServletUtil.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper getObjectMapper() {
        Class<ObjectMapper> clazz = ObjectMapper.class;
        ObjectMapper objectMapper = HttpServletUtil.getSharedObject(clazz);
        if (objectMapper != null) {
            return objectMapper;
        }
        Object object = LOCK;
        synchronized (object) {
            objectMapper = (ObjectMapper)SpringContextHolder.getBean(clazz);
            HttpServletUtil.setSharedObject(clazz, objectMapper);
        }
        return objectMapper;
    }

    private static <C> C getSharedObject(Class<C> clazz) {
        return (C)SHARED_OBJECTS.get(clazz);
    }

    private static <C> void setSharedObject(Class<C> clazz, C object) {
        SHARED_OBJECTS.put(clazz, object);
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        }
    }
}

