/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.core;

import com.elitescloud.cloudt.authorization.api.client.common.CodeChallengeMethod;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.client.util.ProofKeyUtil;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;

public class AuthorizationUtil {
    private static final Logger log = LogManager.getLogger(AuthorizationUtil.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    private AuthorizationUtil() {
    }

    public static String encodeBasicAuth(String clientId, String clientSecret) throws IOException {
        clientId = URLEncoder.encode(clientId, CHARSET);
        clientSecret = URLEncoder.encode(clientSecret, CHARSET);
        String credentialsString = clientId + ":" + clientSecret;
        byte[] encodedBytes = Base64.getEncoder().encode(credentialsString.getBytes(CHARSET));
        String baseAuth = new String(encodedBytes, CHARSET);
        return "Basic " + baseAuth;
    }

    public static String codeChallenge(String codeVerifier) throws Exception {
        return ProofKeyUtil.codeChallenge(CodeChallengeMethod.S256, codeVerifier);
    }

    public static JwtDecoder buildJwtDecoder(@NonNull RSAKey rsaKey) {
        return JwtUtil.buildJwtDecoder(rsaKey);
    }

    public static JwtEncoder buildJwtEncoder(@NonNull RSAKey rsaKey) {
        return JwtUtil.buildJwtEncoder(rsaKey);
    }
}

