package com.elitescloud.cloudt.authorization.api.client.client.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * 客户端配置文件.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/22
 */
@ConfigurationProperties(prefix = OAuthClientProperties.CONFIG_PREFIX)
public class OAuthClientProperties {

    public static final String CONFIG_PREFIX = "elitesland.authorization.client-user";

    /**
     * 是否启用auth2客户端
     */
    private Boolean enabled = false;

    /**
     * 获取token路径
     */
    private String path = "/c/oauth/token";

    /**
     * 特定的用户
     * 认证通过后，若无返回用户，则使用该用户
     */
    private String specifiedUser = "admin";

    /**
     * 读取授权服务器超时时间
     */
    private Duration readTimeout = Duration.ofSeconds(60);

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSpecifiedUser() {
        return specifiedUser;
    }

    public void setSpecifiedUser(String specifiedUser) {
        this.specifiedUser = specifiedUser;
    }

    public Duration getReadTimeout() {
        return readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }
}
