package com.elitescloud.cloudt.authorization.api.client.common;

import org.springframework.http.HttpHeaders;

/**
 * 安全相关常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/25
 */
public interface SecurityConstants {

    /**
     * 缓存中用户的key前缀
     */
    String CACHE_PREFIX_CURRENT_USER = "cloudt:current_user:";

    /**
     * 单点登录的key前缀
     */
    String CACHE_PREFIX_SSO_TICKET = "cloudt:sso:";

    /**
     * 单点登录的token与ticket关联
     */
    String CACHE_PREFIX_SSO_TOKEN = "cloudt:token:sso:";

    /**
     * header  是否支持重定向
     */
    String HEADER_AUTH_REDIRECT = "X-Auth-Redirect";

    /**
     * header  token名称
     */
    String HEADER_TOKEN = HttpHeaders.AUTHORIZATION;

    /**
     * token前缀
     */
    String HEADER_TOKEN_PREFIX = "bearer";

    /**
     * 请求参数中的token名称
     */
    String REQUEST_PARAM_TOKEN = "access_token";
}
